"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TriggersActionsUIHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _breadcrumb = require("./lib/breadcrumb");
var _doc_title = require("./lib/doc_title");
var _health_check = require("./components/health_check");
var _health_context = require("./context/health_context");
var _kibana = require("../common/lib/kibana");
var _suspended_component_with_props = require("./lib/suspended_component_with_props");
var _use_load_rule_types_query = require("./hooks/use_load_rule_types_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RulesList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/rules_list/components/rules_list'))));
const LogsList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./sections/rule_details/components/global_rule_event_log_list'))));
const TriggersActionsUIHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const [headerActions, setHeaderActions] = (0, _react.useState)();
  const {
    chrome,
    setBreadcrumbs
  } = (0, _kibana.useKibana)().services;
  const {
    authorizedToReadAnyRules
  } = (0, _use_load_rule_types_query.useLoadRuleTypesQuery)({
    filteredRuleTypes: []
  });
  const tabs = [];
  tabs.push({
    id: 'rules',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.rulesTabTitle",
      defaultMessage: "Rules"
    })
  });
  if (authorizedToReadAnyRules) {
    tabs.push({
      id: 'logs',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.home.logsTabTitle",
        defaultMessage: "Logs"
      })
    });
  }
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  const renderRulesList = (0, _react.useCallback)(() => {
    return (0, _suspended_component_with_props.suspendedComponentWithProps)(RulesList, 'xl')({
      showCreateRuleButtonInPrompt: true,
      setHeaderActions
    });
  }, []);
  const renderLogsList = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none"
    }, (0, _suspended_component_with_props.suspendedComponentWithProps)(LogsList, 'xl')({
      setHeaderActions
    }));
  }, []);

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)(section || 'home')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)(section || 'home'));
  }, [section, chrome, setBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    paddingSize: "none",
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.appTitle",
      defaultMessage: "Rules"
    })),
    rightSideItems: headerActions,
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.home.sectionDescription",
      defaultMessage: "Detect conditions using rules."
    }),
    tabs: tabs.map(tab => ({
      label: tab.name,
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_health_context.HealthContextProvider, null, /*#__PURE__*/_react.default.createElement(_health_check.HealthCheck, {
    waitForCheck: true
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToLogs,
    component: renderLogsList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToRules,
    component: renderRulesList
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.TriggersActionsUIHome = TriggersActionsUIHome;