"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextAreaWithMessageVariables = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _get_experimental_features = require("../../common/get_experimental_features");
var _text_area_with_autocomplete = require("./text_area_with_autocomplete");
var _lib = require("../lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextAreaWithMessageVariablesLegacy = ({
  messageVariables,
  paramsProperty,
  index,
  inputTargetValue,
  isDisabled = false,
  editAction,
  label,
  errors,
  helpText
}) => {
  const [currentTextElement, setCurrentTextElement] = (0, _react.useState)(null);
  const onSelectMessageVariable = variable => {
    var _currentTextElement$s, _currentTextElement$s2;
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    const startPosition = (_currentTextElement$s = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionStart) !== null && _currentTextElement$s !== void 0 ? _currentTextElement$s : 0;
    const endPosition = (_currentTextElement$s2 = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionEnd) !== null && _currentTextElement$s2 !== void 0 ? _currentTextElement$s2 : 0;
    const newValue = (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(0, startPosition) + templatedVar + (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(endPosition, (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').length);
    editAction(paramsProperty, newValue, index);
  };
  const onChangeWithMessageVariable = e => {
    editAction(paramsProperty, e.target.value, index);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors,
    isDisabled: isDisabled,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    labelAppend: /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
      messageVariables: messageVariables,
      onSelectEventHandler: onSelectMessageVariable,
      paramsProperty: paramsProperty
    }),
    helpText: helpText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    disabled: isDisabled,
    fullWidth: true,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    name: paramsProperty,
    value: inputTargetValue || '',
    "data-test-subj": `${paramsProperty}TextArea`,
    onChange: e => onChangeWithMessageVariable(e),
    onFocus: e => {
      setCurrentTextElement(e.target);
    },
    onBlur: () => {
      if (!inputTargetValue) {
        editAction(paramsProperty, '', index);
      }
    }
  }));
};
const TextAreaWithMessageVariables = props => {
  let isMustacheAutocompleteOn;
  try {
    isMustacheAutocompleteOn = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('isMustacheAutocompleteOn');
  } catch (e) {
    isMustacheAutocompleteOn = false;
  }
  if (isMustacheAutocompleteOn) return (0, _text_area_with_autocomplete.TextAreaWithAutocomplete)(props);
  return TextAreaWithMessageVariablesLegacy(props);
};
exports.TextAreaWithMessageVariables = TextAreaWithMessageVariables;