"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsRange = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSettingsRange = exports.RulesSettingsRange = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    label,
    labelPopoverText,
    min,
    max,
    value,
    disabled,
    onChange,
    ...rest
  } = props;
  const renderLabel = () => {
    return /*#__PURE__*/_react.default.createElement("div", null, label, "\xA0", labelPopoverText && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      size: "s",
      type: "questionInCircle",
      content: labelPopoverText
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: renderLabel()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, (0, _extends2.default)({
    min: min,
    max: max,
    step: 1,
    value: value,
    disabled: disabled,
    onChange: onChange,
    showLabels: true,
    showValue: true
  }, rest)));
});