"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesSettingsModal = exports.RulesSettingsErrorPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../common/lib/kibana");
var _use_get_flapping_settings = require("../../hooks/use_get_flapping_settings");
var _rules_settings_flapping_section = require("./flapping/rules_settings_flapping_section");
var _rules_settings_query_delay_section = require("./query_delay/rules_settings_query_delay_section");
var _use_get_query_delay_settings = require("../../hooks/use_get_query_delay_settings");
var _use_update_rules_settings = require("../../hooks/use_update_rules_settings");
var _center_justified_spinner = require("../center_justified_spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSettingsErrorPrompt = exports.RulesSettingsErrorPrompt = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "rulesSettingsErrorPrompt",
    color: "danger",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.errorPromptTitle",
      defaultMessage: "Unable to load your rules settings"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.rulesSettings.modal.errorPromptBody",
      defaultMessage: "There was an error loading your rules settings. Contact your administrator for help"
    }))
  });
});
const useResettableState = initalValue => {
  const initialValueRef = (0, _react.useRef)(initalValue);
  const [value, setValue] = (0, _react.useState)(initalValue);
  const [hasChanged, setHasChanged] = (0, _react.useState)(false);
  const reset = () => {
    setValue(initialValueRef.current);
    setHasChanged(false);
  };
  const updateValue = (next, shouldUpdateInitialValue = false) => {
    setValue(next);
    setHasChanged(true);
    if (shouldUpdateInitialValue) initialValueRef.current = next;
  };
  return [value, hasChanged, updateValue, reset];
};
const RulesSettingsModal = exports.RulesSettingsModal = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    isVisible,
    onClose,
    setUpdatingRulesSettings,
    onSave
  } = props;
  const {
    application: {
      capabilities
    },
    isServerless
  } = (0, _kibana.useKibana)().services;
  const {
    rulesSettings: {
      writeFlappingSettingsUI,
      readFlappingSettingsUI,
      writeQueryDelaySettingsUI,
      readQueryDelaySettingsUI
    }
  } = capabilities;
  const [flappingSettings, hasFlappingChanged, setFlappingSettings, resetFlappingSettings] = useResettableState();
  const [queryDelaySettings, hasQueryDelayChanged, setQueryDelaySettings, resetQueryDelaySettings] = useResettableState();
  const {
    isLoading: isFlappingLoading,
    isError: hasFlappingError
  } = (0, _use_get_flapping_settings.useGetFlappingSettings)({
    enabled: isVisible,
    onSuccess: fetchedSettings => {
      if (!flappingSettings) {
        setFlappingSettings({
          enabled: fetchedSettings.enabled,
          lookBackWindow: fetchedSettings.lookBackWindow,
          statusChangeThreshold: fetchedSettings.statusChangeThreshold
        }, true // Update the initial value so we don't need to fetch it from the server again
        );
      }
    }
  });
  const {
    isLoading: isQueryDelayLoading,
    isError: hasQueryDelayError
  } = (0, _use_get_query_delay_settings.useGetQueryDelaySettings)({
    enabled: isVisible,
    onSuccess: fetchedSettings => {
      if (!queryDelaySettings) {
        setQueryDelaySettings({
          delay: fetchedSettings.delay
        }, true);
      }
    }
  });
  const onCloseModal = (0, _react.useCallback)(() => {
    resetFlappingSettings();
    resetQueryDelaySettings();
    onClose();
  }, [onClose, resetFlappingSettings, resetQueryDelaySettings]);
  const {
    mutate
  } = (0, _use_update_rules_settings.useUpdateRuleSettings)({
    onSave,
    onClose,
    setUpdatingRulesSettings
  });

  // In the future when we have more settings sub-features, we should
  // disassociate the rule settings capabilities (save, show) from the
  // sub-feature capabilities (writeXSettingsUI).
  const canWriteFlappingSettings = writeFlappingSettingsUI && !hasFlappingError;
  const canShowFlappingSettings = readFlappingSettingsUI;
  const canWriteQueryDelaySettings = writeQueryDelaySettingsUI && !hasQueryDelayError;
  const canShowQueryDelaySettings = readQueryDelaySettingsUI;
  const handleSettingsChange = (setting, key, value) => {
    if (setting === 'flapping') {
      if (!flappingSettings) {
        return;
      }
      const newSettings = {
        ...flappingSettings,
        [key]: value
      };
      setFlappingSettings({
        ...newSettings,
        statusChangeThreshold: Math.min(newSettings.lookBackWindow, newSettings.statusChangeThreshold)
      });
    }
    if (setting === 'queryDelay') {
      if (!queryDelaySettings) {
        return;
      }
      const newSettings = {
        ...queryDelaySettings,
        [key]: value
      };
      setQueryDelaySettings(newSettings);
    }
  };
  const handleSave = () => {
    const updatedSettings = {};
    if (canWriteFlappingSettings && hasFlappingChanged) {
      updatedSettings.flapping = flappingSettings;
      setFlappingSettings(flappingSettings, true);
    }
    if (canWriteQueryDelaySettings && hasQueryDelayChanged) {
      updatedSettings.queryDelay = queryDelaySettings;
      setQueryDelaySettings(queryDelaySettings, true);
    }
    mutate(updatedSettings);
  };
  if (!isVisible) {
    return null;
  }
  const maybeRenderForm = () => {
    if (!canShowFlappingSettings && !canShowQueryDelaySettings) {
      return /*#__PURE__*/_react.default.createElement(RulesSettingsErrorPrompt, null);
    }
    if (isFlappingLoading || isQueryDelayLoading) {
      return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, flappingSettings && /*#__PURE__*/_react.default.createElement(_rules_settings_flapping_section.RulesSettingsFlappingSection, {
      onChange: (key, value) => handleSettingsChange('flapping', key, value),
      settings: flappingSettings,
      canWrite: canWriteFlappingSettings,
      canShow: canShowFlappingSettings,
      hasError: hasFlappingError
    }), isServerless && queryDelaySettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rules_settings_query_delay_section.RulesSettingsQueryDelaySection, {
      onChange: (key, value) => handleSettingsChange('queryDelay', key, value),
      settings: queryDelaySettings,
      canWrite: canWriteQueryDelaySettings,
      canShow: canShowQueryDelaySettings,
      hasError: hasQueryDelayError
    })));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "rulesSettingsModal",
    onClose: onCloseModal,
    maxWidth: 880
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    component: "h3"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.title",
    defaultMessage: "Rule settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.calloutMessage', {
      defaultMessage: 'Apply to all rules within the current space.'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), maybeRenderForm(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "rulesSettingsModalCancelButton",
    onClick: onCloseModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.cancelButton",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "rulesSettingsModalSaveButton",
    onClick: handleSave,
    disabled: !canWriteFlappingSettings && !canWriteQueryDelaySettings
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.modal.saveButton",
    defaultMessage: "Save"
  }))));
});