"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTableConfigRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AlertTableConfigRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "objectTypes", new Map());
  }
  /**
   * Returns if the object type registry has the given type registered
   */
  has(id) {
    return this.objectTypes.has(id);
  }

  /**
   * Registers an object type to the type registry
   */
  register(objectType) {
    if (this.has(objectType.id)) {
      throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.typeRegistry.register.duplicateObjectTypeErrorMessage', {
        defaultMessage: 'Object type "{id}" is already registered.',
        values: {
          id: objectType.id
        }
      }));
    }
    this.objectTypes.set(objectType.id, objectType);
  }

  /**
   * Returns an object type, throw error if not registered
   */
  get(id) {
    if (!this.has(id)) {
      throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.typeRegistry.get.missingActionTypeErrorMessage', {
        defaultMessage: 'Object type "{id}" is not registered.',
        values: {
          id
        }
      }));
    }
    return this.objectTypes.get(id);
  }
  getActions(id) {
    var _actions, _this$objectTypes$get;
    return (_actions = (_this$objectTypes$get = this.objectTypes.get(id)) === null || _this$objectTypes$get === void 0 ? void 0 : _this$objectTypes$get.actions) !== null && _actions !== void 0 ? _actions : {
      toggleColumn: _lodash.noop
    };
  }
  list() {
    return Array.from(this.objectTypes).map(([id, objectType]) => objectType);
  }

  /**
   * Returns an object type, throw error if not registered
   */
  update(id, objectType) {
    if (!this.has(id)) {
      throw new Error(_i18n.i18n.translate('xpack.triggersActionsUI.typeRegistry.get.missingActionTypeErrorMessage', {
        defaultMessage: 'Object type "{id}" is not registered.',
        values: {
          id
        }
      }));
    }
    this.objectTypes.set(id, objectType);
    return this.objectTypes.get(id);
  }
  getAlertConfigIdPerRuleTypes(ruleTypeIds) {
    const alertConfigs = [];
    Array.from(this.objectTypes).forEach(([id, objectType]) => {
      if (ruleTypeIds.every(ruleTypeId => {
        var _objectType$ruleTypeI;
        return (_objectType$ruleTypeI = objectType.ruleTypeIds) === null || _objectType$ruleTypeI === void 0 ? void 0 : _objectType$ruleTypeI.includes(ruleTypeId);
      })) {
        alertConfigs.push(id);
      }
    });
    if (alertConfigs.length === 1) {
      return alertConfigs[0];
    }
    // If there is more than one, we will return the generic alert configuration id
    return _constants.ALERT_TABLE_GENERIC_CONFIG_ID;
  }
}
exports.AlertTableConfigRegistry = AlertTableConfigRegistry;