"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _stop_transforms = require("../../../../common/api_schemas/stop_transforms");
var _constants = require("../../../../common/constants");
var _route_handler = require("./route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute({
  router,
  license
}) {
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/stop_transforms Stop transforms
   * @apiName PostStopTransforms
   * @apiDescription Stops transform
   *
   * @apiSchema (body) stopTransformsRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('stop_transforms'),
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _stop_transforms.stopTransformsRequestSchema
      }
    }
  }, license.guardApiRoute(_route_handler.routeHandler));
}