"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ISSUE_DETECTED = exports.TRANSFORM_ISSUE = exports.TRANSFORM_HEALTH_AAD_INDEX_NAME = exports.TRANSFORM_HEALTH_AAD_CONFIG = void 0;
exports.getTransformHealthRuleType = getTransformHealthRuleType;
exports.registerTransformHealthRuleType = registerTransformHealthRuleType;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fieldTypes = require("@kbn/field-types");
var _constants = require("../../../../common/constants");
var _schema = require("./schema");
var _transform_health_service = require("./transform_health_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated This health check is no longer in use
 */

const TRANSFORM_ISSUE = exports.TRANSFORM_ISSUE = 'transform_issue';
const TRANSFORM_ISSUE_DETECTED = exports.TRANSFORM_ISSUE_DETECTED = {
  id: TRANSFORM_ISSUE,
  name: _i18n.i18n.translate('xpack.transform.alertingRuleTypes.transformHealth.actionGroupName', {
    defaultMessage: 'Issue detected'
  })
};
const TRANSFORM_HEALTH_AAD_INDEX_NAME = exports.TRANSFORM_HEALTH_AAD_INDEX_NAME = 'transform.health';
const TRANSFORM_HEALTH_AAD_CONFIG = exports.TRANSFORM_HEALTH_AAD_CONFIG = {
  context: TRANSFORM_HEALTH_AAD_INDEX_NAME,
  mappings: {
    fieldMap: {
      [_constants.TRANSFORM_HEALTH_RESULTS]: {
        type: _fieldTypes.ES_FIELD_TYPES.OBJECT,
        array: true,
        required: false,
        dynamic: false,
        properties: {
          transform_id: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          description: {
            type: _fieldTypes.ES_FIELD_TYPES.TEXT
          },
          health_status: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          issues: {
            type: _fieldTypes.ES_FIELD_TYPES.OBJECT
          },
          transform_state: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          },
          node_name: {
            type: _fieldTypes.ES_FIELD_TYPES.KEYWORD
          }
        }
      }
    }
  },
  shouldWrite: true
};
function registerTransformHealthRuleType(params) {
  const {
    alerting
  } = params;
  alerting.registerType(getTransformHealthRuleType(params.getFieldFormatsStart));
}
function getTransformHealthRuleType(getFieldFormatsStart) {
  return {
    id: _constants.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH,
    name: _i18n.i18n.translate('xpack.transform.alertingRuleTypes.transformHealth.name', {
      defaultMessage: 'Transform health'
    }),
    actionGroups: [TRANSFORM_ISSUE_DETECTED],
    defaultActionGroupId: TRANSFORM_ISSUE,
    validate: {
      params: _schema.transformHealthRuleParams
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _schema.transformHealthRuleParams
      }
    },
    actionVariables: {
      context: [{
        name: 'results',
        description: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.alertContext.resultsDescription', {
          defaultMessage: 'Rule execution results'
        })
      }, {
        name: 'message',
        description: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.alertContext.messageDescription', {
          defaultMessage: 'Alert info message'
        })
      }]
    },
    category: _server.DEFAULT_APP_CATEGORIES.management.id,
    producer: 'stackAlerts',
    minimumLicenseRequired: _constants.PLUGIN.MINIMUM_LICENSE_REQUIRED,
    isExportable: true,
    doesSetRecoveryContext: true,
    alerts: TRANSFORM_HEALTH_AAD_CONFIG,
    async executor(options) {
      const {
        services: {
          scopedClusterClient,
          alertsClient,
          uiSettingsClient
        },
        params
      } = options;
      if (!alertsClient) {
        throw new _server2.AlertsClientError();
      }
      const fieldFormatsRegistry = await getFieldFormatsStart().fieldFormatServiceFactory(uiSettingsClient);
      const transformHealthService = (0, _transform_health_service.transformHealthServiceProvider)({
        esClient: scopedClusterClient.asCurrentUser,
        fieldFormatsRegistry
      });
      const executionResult = await transformHealthService.getHealthChecksResults(params);
      const unhealthyTests = executionResult.filter(({
        isHealthy
      }) => !isHealthy);
      if (unhealthyTests.length > 0) {
        unhealthyTests.forEach(({
          name: alertInstanceName,
          context
        }) => {
          alertsClient.report({
            id: alertInstanceName,
            actionGroup: TRANSFORM_ISSUE,
            context,
            payload: {
              [_ruleDataUtils.ALERT_REASON]: context.message,
              [_constants.TRANSFORM_HEALTH_RESULTS]: context.results
            }
          });
        });
      }

      // Set context for recovered alerts
      for (const recoveredAlert of alertsClient.getRecoveredAlerts()) {
        const recoveredAlertId = recoveredAlert.alert.getId();
        const testResult = executionResult.find(v => v.name === recoveredAlertId);
        if (testResult) {
          alertsClient.setAlertData({
            id: recoveredAlertId,
            context: testResult.context,
            payload: {
              [_ruleDataUtils.ALERT_REASON]: testResult.context.message,
              [_constants.TRANSFORM_HEALTH_RESULTS]: testResult.context.results
            }
          });
        }
      }
      return {
        state: {}
      };
    }
  };
}