"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformManagementSection = exports.TransformManagement = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _app_dependencies = require("../../app_dependencies");
var _transform_stats = require("../../../../common/types/transform_stats");
var _use_get_transform_stats = require("../../hooks/use_get_transform_stats");
var _serverless_context = require("../../serverless_context");
var _reauthorization_utils = require("../../common/reauthorization_utils");
var _constants = require("../../../../common/constants");
var _hooks = require("../../hooks");
var _navigation = require("../../common/navigation");
var _capabilities_wrapper = require("../../components/capabilities_wrapper");
var _toast_notification_text = require("../../components/toast_notification_text");
var _navigation2 = require("../../services/navigation");
var _search_selection = require("./components/search_selection");
var _transform_list = require("./components/transform_list");
var _transforms_stats_bar = require("./components/transform_list/transforms_stats_bar");
var _transform_alerting_flyout = require("../../../alerting/transform_alerting_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorMessageCallout = ({
  text,
  errorMessage
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text, ' ', errorMessage !== null && /*#__PURE__*/_react.default.createElement(_toast_notification_text.ToastNotificationText, {
      inline: true,
      forceModal: true,
      text: errorMessage
    })),
    color: "danger",
    iconType: "error"
  }));
};
const TransformManagement = () => {
  const {
    esTransform
  } = (0, _hooks.useDocumentationLinks)();
  const {
    showNodeInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const {
    dataViewEditor
  } = (0, _app_dependencies.useAppDependencies)();
  const deleteTransforms = (0, _hooks.useDeleteTransforms)();
  const {
    isInitialLoading: transformNodesInitialLoading,
    error: transformNodesErrorMessage,
    data: transformNodesData = 0
  } = (0, _hooks.useGetTransformNodes)({
    enabled: true
  });
  const transformNodes = transformNodesErrorMessage === null ? transformNodesData : 0;
  const {
    isInitialLoading: transformsInitialLoading,
    isLoading: transformsWithoutStatsLoading,
    error: transformsErrorMessage,
    data: {
      transforms: transformsWithoutStats,
      transformIdsWithoutConfig
    }
  } = (0, _hooks.useGetTransforms)({
    enabled: !transformNodesInitialLoading && transformNodes > 0
  });
  const {
    isLoading: transformsStatsLoading,
    error: transformsStatsErrorMessage,
    data: transformsStats
  } = (0, _use_get_transform_stats.useGetTransformsStats)({
    basic: true,
    enabled: !transformNodesInitialLoading && transformNodes > 0
  });
  const transforms = (0, _react.useMemo)(() => {
    if (!transformsStats) return transformsWithoutStats;
    return transformsWithoutStats.map(t => {
      const stats = transformsStats.transforms.find(d => t.config.id === d.id);

      // A newly created transform might not have corresponding stats yet.
      // If that's the case we just skip the transform and don't add it to the transform list yet.
      if (!(0, _transform_stats.isTransformStats)(stats)) {
        return t;
      }
      return {
        ...t,
        stats
      };
    });
  }, [transformsStats, transformsWithoutStats]);
  const isInitialLoading = transformNodesInitialLoading || transformsInitialLoading;
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const unauthorizedTransformsWarning = (0, _react.useMemo)(() => {
    const unauthorizedCnt = transforms.filter(t => (0, _reauthorization_utils.needsReauthorization)(t)).length;
    if (!unauthorizedCnt) return null;
    const insufficientPermissionsMsg = _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.insufficientPermissionsMsg', {
      defaultMessage: '{unauthorizedCnt, plural, one {A transform was created with insufficient permissions.} other {# transforms were created with insufficient permissions.}}',
      values: {
        unauthorizedCnt
      }
    });
    const actionMsg = canStartStopTransform ? _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.reauthorizeMsg', {
      defaultMessage: 'Reauthorize to start {unauthorizedCnt, plural, one {transform} other {# transforms}}.',
      values: {
        unauthorizedCnt
      }
    }) : _i18n.i18n.translate('xpack.transform.transformList.unauthorizedTransformsCallout.contactAdminMsg', {
      defaultMessage: 'Contact your administrator to request the required permissions.'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "alert",
      color: "warning",
      "data-test-subj": "transformPageReauthorizeCallout",
      title: `${insufficientPermissionsMsg} ${actionMsg}`
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }, [transforms, canStartStopTransform]);
  const [isSearchSelectionVisible, setIsSearchSelectionVisible] = (0, _react.useState)(false);
  const [savedObjectId, setSavedObjectId] = (0, _react.useState)(null);
  const onCloseModal = (0, _react.useCallback)(() => setIsSearchSelectionVisible(false), []);
  const onOpenModal = () => setIsSearchSelectionVisible(true);
  const onSearchSelected = (0, _react.useCallback)((id, type) => {
    setSavedObjectId(id);
  }, []);
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView());
  const closeDataViewEditorRef = (0, _react.useRef)();
  const createNewDataView = (0, _react.useCallback)(() => {
    onCloseModal();
    closeDataViewEditorRef.current = dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.openEditor({
      onSave: async dataView => {
        if (dataView.id) {
          onSearchSelected(dataView.id, 'index-pattern');
        }
      },
      allowAdHocDataView: true
    });
  }, [dataViewEditor, onCloseModal, onSearchSelected]);
  (0, _react.useEffect)(function cleanUpDataViewEditorFlyout() {
    return () => {
      // Close the editor when unmounting
      if (closeDataViewEditorRef.current) {
        closeDataViewEditorRef.current();
      }
    };
  }, []);
  if (savedObjectId !== null) {
    return /*#__PURE__*/_react.default.createElement(_navigation.RedirectToCreateTransform, {
      savedObjectId: savedObjectId
    });
  }
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "help",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformList.transformDocsLinkText",
    defaultMessage: "Transform docs"
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "transformAppTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformTitle",
      defaultMessage: "Transforms"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.transformDescription",
      defaultMessage: "Use transforms to pivot existing Elasticsearch indices into summarized entity-centric indices or to create an indexed view of the latest documents for fast access."
    }),
    rightSideItems: [docsLink],
    bottomBorder: true,
    paddingSize: 'none'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: 'none',
    "data-test-subj": "transformPageTransformList"
  }, isInitialLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 2
  })), !isInitialLoading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, unauthorizedTransformsWarning, showNodeInfo && transformNodesErrorMessage !== null && /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformNodesErrorPromptTitle",
      defaultMessage: "An error occurred getting the number of transform nodes."
    }),
    errorMessage: transformNodesErrorMessage
  }), transformsErrorMessage !== null && /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformListErrorPromptTitle",
      defaultMessage: "An error occurred getting the transform list."
    }),
    errorMessage: transformsErrorMessage
  }), transformsStatsErrorMessage !== null ? /*#__PURE__*/_react.default.createElement(ErrorMessageCallout, {
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.list.transformStatsErrorPromptTitle",
      defaultMessage: "An error occurred getting the transform stats."
    }),
    errorMessage: transformsStatsErrorMessage
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_transforms_stats_bar.TransformStatsBar, {
    transformNodes: transformNodes,
    transformsList: transforms
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.AlertRulesManageContext.Provider, {
    value: (0, _transform_alerting_flyout.getAlertRuleManageContext)()
  }, transformIdsWithoutConfig ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.danglingTasksError",
    defaultMessage: "{count} {count, plural, one {transform is} other {transforms are}} missing configuration details: [{transformIds}] {count, plural, one {It} other {They}} cannot be recovered and should be deleted.",
    values: {
      count: transformIdsWithoutConfig.length,
      transformIds: transformIdsWithoutConfig.join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    size: "s",
    onClick: () => deleteTransforms(
    // If transform task doesn't have any corresponding config
    // we won't know what the destination index or data view would be
    // and should be force deleted
    {
      transformsInfo: transformIdsWithoutConfig.map(id => ({
        id,
        state: _constants.TRANSFORM_STATE.FAILED
      })),
      deleteDestIndex: false,
      deleteDestDataView: false,
      forceDelete: true
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.forceDeleteTransformMessage",
    defaultMessage: "Delete {count} {count, plural, one {transform} other {transforms}}",
    values: {
      count: transformIdsWithoutConfig.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, (transformNodes > 0 || transforms.length > 0) && /*#__PURE__*/_react.default.createElement(_transform_list.TransformList, {
    isLoading: transformsWithoutStatsLoading,
    onCreateTransform: onOpenModal,
    transformNodes: transformNodes,
    transforms: transforms,
    transformsLoading: transformsWithoutStatsLoading,
    transformsStatsLoading: transformsStatsLoading
  }), /*#__PURE__*/_react.default.createElement(_transform_alerting_flyout.TransformAlertFlyoutWrapper, null)))), isSearchSelectionVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCloseModal,
    className: "transformCreateTransformSearchDialog",
    "data-test-subj": "transformSelectSourceModal"
  }, /*#__PURE__*/_react.default.createElement(_search_selection.SearchSelection, {
    onSearchSelected: onSearchSelected,
    canEditDataView: canEditDataView,
    createNewDataView: createNewDataView
  })));
};
exports.TransformManagement = TransformManagement;
const TransformManagementSection = () => {
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation2.breadcrumbService.setBreadcrumbs(_navigation2.BREADCRUMB_SECTION.HOME);
    _navigation2.docTitleService.setTitle('home');
  }, []);
  return /*#__PURE__*/_react.default.createElement(_capabilities_wrapper.CapabilitiesWrapper, {
    requiredCapabilities: 'canGetTransform'
  }, /*#__PURE__*/_react.default.createElement(TransformManagement, null));
};
exports.TransformManagementSection = TransformManagementSection;