"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowPreviewPane = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _mlDataGrid = require("@kbn/ml-data-grid");
var _app_dependencies = require("../../../../app_dependencies");
var _common = require("../../../../common");
var _use_transform_config_data = require("../../../../hooks/use_transform_config_data");
var _step_define = require("../../../create_transform/components/step_define");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowPreviewPane = ({
  transformConfig
}) => {
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    searchQuery,
    validationStatus,
    previewRequest,
    runtimeMappings
  } = (0, _react.useMemo)(() => (0, _step_define.applyTransformConfigToDefineState)((0, _step_define.getDefaultStepDefineState)({}), transformConfig), [transformConfig]);
  const transformConfigQuery = (0, _react.useMemo)(() => (0, _common.getTransformConfigQuery)(searchQuery), [searchQuery]);
  const dataViewTitle = Array.isArray(transformConfig.source.index) ? transformConfig.source.index.join(',') : transformConfig.source.index;
  const pivotPreviewProps = (0, _use_transform_config_data.useTransformConfigData)({
    getIndexPattern: () => dataViewTitle
  }, transformConfigQuery, validationStatus, previewRequest, runtimeMappings);
  return /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, pivotPreviewProps, {
    dataTestSubj: "transformPivotPreview",
    toastNotifications: toastNotifications
  }));
};
exports.ExpandedRowPreviewPane = ExpandedRowPreviewPane;