"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyoutCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_documentation_links = require("../../../hooks/use_documentation_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditTransformFlyoutCallout = () => {
  const {
    esTransformUpdate
  } = (0, _use_documentation_links.useDocumentationLinks)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "help"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutCalloutText', {
    defaultMessage: 'This form allows you to update a transform. The list of properties that you can update is a subset of the list that you can define when you create a transform.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: esTransformUpdate,
    target: "_BLANK"
  }, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutCalloutDocs', {
    defaultMessage: 'View docs'
  })))));
};
exports.EditTransformFlyoutCallout = EditTransformFlyoutCallout;