"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTransform = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetTransform = (transformId, enabled) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_TRANSFORM, transformId], ({
    signal
  }) => http.get((0, _constants.addInternalBasePath)(`transforms/${transformId}`), {
    version: '1',
    signal
  }), {
    enabled
  });
};
exports.useGetTransform = useGetTransform;