"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetHistogramsForFields = void 0;
var _reactQuery = require("@tanstack/react-query");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetHistogramsForFields = (dataViewTitle, fields, query, runtimeMappings, enabled, samplerShardSize = _mlAggUtils.DEFAULT_SAMPLER_SHARD_SIZE) => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _reactQuery.useQuery)([_constants.TRANSFORM_REACT_QUERY_KEYS.GET_HISTOGRAMS_FOR_FIELDS, {
    dataViewTitle,
    fields,
    query,
    runtimeMappings,
    samplerShardSize
  }], ({
    signal
  }) => http.post((0, _constants.addInternalBasePath)(`field_histograms/${dataViewTitle}`), {
    body: JSON.stringify({
      query,
      fields,
      samplerShardSize,
      ...(runtimeMappings !== undefined ? {
        runtimeMappings
      } : {})
    }),
    version: '1',
    signal
  }), {
    enabled
  });
};
exports.useGetHistogramsForFields = useGetHistogramsForFields;