"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidTimeZone = exports.ACCEPTED_TIMEZONES = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _mlIsDefined = require("@kbn/ml-is-defined");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Partial list of packages/core/ui-settings/core-ui-settings-common/src/timezones.ts
const ACCEPTED_TIMEZONES = exports.ACCEPTED_TIMEZONES = new Set([..._momentTimezone.default.tz.names()
// We need to filter out some time zones, that moment.js knows about, but Elasticsearch
// does not understand and would fail thus with a 400 bad request when using them.
.filter(tz => !['America/Nuuk', 'EST', 'HST', 'ROC', 'MST'].includes(tz))]);
const isValidTimeZone = arg => (0, _mlIsDefined.isDefined)(arg) && typeof arg === 'string' && ACCEPTED_TIMEZONES.has(arg);
exports.isValidTimeZone = isValidTimeZone;