"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NESTED_COLUMN = exports.COLUMN_TOGGLE_KEYBOARD_SHORTCUT = exports.COLUMN_TOGGLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _types = require("../../../../common/types");
var _accessibility = require("../../../../common/utils/accessibility");
var _tooltip_with_keyboard_shortcut = require("../../tooltip_with_keyboard_shortcut");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLUMN_TOGGLE = field => _i18n.i18n.translate('xpack.timelines.hoverActions.columnToggleLabel', {
  values: {
    field
  },
  defaultMessage: 'Toggle {field} column in table'
});
exports.COLUMN_TOGGLE = COLUMN_TOGGLE;
const NESTED_COLUMN = field => _i18n.i18n.translate('xpack.timelines.hoverActions.nestedColumnToggleLabel', {
  values: {
    field
  },
  defaultMessage: 'The {field} field is an object, and is broken down into nested fields which can be added as columns'
});
exports.NESTED_COLUMN = NESTED_COLUMN;
const COLUMN_TOGGLE_KEYBOARD_SHORTCUT = exports.COLUMN_TOGGLE_KEYBOARD_SHORTCUT = 'i';
const ColumnToggleButton = exports.default = /*#__PURE__*/_react.default.memo(({
  Component,
  defaultFocusedButtonRef,
  field,
  isDisabled,
  isObjectArray,
  keyboardEvent,
  ownFocus,
  onClick,
  showTooltip = false,
  toggleColumn,
  value
}) => {
  const label = isObjectArray ? NESTED_COLUMN(field) : COLUMN_TOGGLE(field);
  const handleToggleColumn = (0, _react.useCallback)(() => {
    toggleColumn({
      columnHeaderType: _types.defaultColumnHeaderType,
      id: field,
      initialWidth: _constants.DEFAULT_COLUMN_MIN_WIDTH
    });
    if (onClick != null) {
      onClick();
    }
  }, [onClick, field, toggleColumn]);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === COLUMN_TOGGLE_KEYBOARD_SHORTCUT) {
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      handleToggleColumn();
    }
  }, [handleToggleColumn, keyboardEvent, ownFocus]);
  const button = (0, _react.useMemo)(() => Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": label,
    "data-test-subj": `toggle-field-${field}`,
    icon: "listAdd",
    iconType: "listAdd",
    onClick: handleToggleColumn,
    title: label
  }, label) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": label,
    buttonRef: defaultFocusedButtonRef,
    className: "timelines__hoverActionButton",
    "data-test-subj": `toggle-field-${field}`,
    "data-colindex": 1,
    disabled: isDisabled,
    id: field,
    iconSize: "s",
    iconType: "listAdd",
    onClick: handleToggleColumn
  }), [Component, defaultFocusedButtonRef, field, handleToggleColumn, isDisabled, label]);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: label,
      shortcut: COLUMN_TOGGLE_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus
    })
  }, button) : button;
});
ColumnToggleButton.displayName = 'ColumnToggleButton';

// eslint-disable-next-line import/no-default-export