"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelineEventsLastEventTimeRequestSchema = exports.LastEventIndexKey = void 0;
var _zod = require("zod");
var _timeline_events_queries = require("../model/timeline_events_queries");
var _request_basic = require("./request_basic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let LastEventIndexKey = exports.LastEventIndexKey = /*#__PURE__*/function (LastEventIndexKey) {
  LastEventIndexKey["hostDetails"] = "hostDetails";
  LastEventIndexKey["hosts"] = "hosts";
  LastEventIndexKey["users"] = "users";
  LastEventIndexKey["userDetails"] = "userDetails";
  LastEventIndexKey["ipDetails"] = "ipDetails";
  LastEventIndexKey["network"] = "network";
  return LastEventIndexKey;
}({});
const timelineEventsLastEventTimeRequestSchema = exports.timelineEventsLastEventTimeRequestSchema = _request_basic.timelineRequestBasicOptionsSchema.omit({
  runtimeMappings: true,
  filterQuery: true,
  timerange: true
}).extend({
  indexKey: _zod.z.enum([LastEventIndexKey.hostDetails, LastEventIndexKey.hosts, LastEventIndexKey.users, LastEventIndexKey.userDetails, LastEventIndexKey.ipDetails, LastEventIndexKey.network]),
  details: _zod.z.object({
    hostName: _zod.z.string().nullable().optional(),
    userName: _zod.z.string().nullable().optional(),
    ip: _zod.z.string().nullable().optional()
  }),
  factoryQueryType: _zod.z.literal(_timeline_events_queries.TimelineEventsQueries.lastEventTime)
});