"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexFieldsRequestSchema = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexFieldsRequestBase = _zod.z.object({
  onlyCheckIfIndicesExist: _zod.z.boolean().optional(),
  includeUnmapped: _zod.z.boolean().optional()
});
const indexFieldsRequestSchema = exports.indexFieldsRequestSchema = _zod.z.union([indexFieldsRequestBase.extend({
  indices: _zod.z.array(_zod.z.string())
}), indexFieldsRequestBase.extend({
  dataViewId: _zod.z.string()
})]);