"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToTimeline = void 0;
var _data_provider = require("../utils/data_provider");
var _field_value = require("../../indicators/utils/field_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom hook that gets an {@link Indicator}, retrieves the field (from the RawIndicatorFieldId.Name)
 * and value, then creates DataProviders used to do the Investigate in Timeline logic
 * (see /kibana/x-pack/plugins/security_solution/public/threat_intelligence/use_investigate_in_timeline.ts)
 */
const useAddToTimeline = ({
  indicator,
  field
}) => {
  const {
    key,
    value
  } = typeof indicator === 'string' ? {
    key: field,
    value: indicator
  } : (0, _field_value.getIndicatorFieldAndValue)(indicator, field);
  if (!(0, _field_value.fieldAndValueValid)(key, value)) {
    return {};
  }
  const dataProvider = [(0, _data_provider.generateDataProvider)(key, value)];
  const addToTimelineProps = {
    dataProvider,
    field: key,
    ownFocus: false
  };
  return {
    addToTimelineProps
  };
};
exports.useAddToTimeline = useAddToTimeline;