"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_block_list_context = require("../hooks/use_block_list_context");
var _block_list_provider = require("../containers/block_list_provider");
var _flyout = require("../../block_list/containers/flyout");
var _wrapper = require("../components/barchart/wrapper");
var _table = require("../components/table/table");
var _use_aggregated_indicators = require("../hooks/use_aggregated_indicators");
var _use_indicators = require("../hooks/use_indicators");
var _use_sourcerer_data_view = require("../hooks/use_sourcerer_data_view");
var _layout = require("../../../components/layout");
var _use_filters = require("../../query_bar/hooks/use_filters");
var _filters_global = require("../../../containers/filters_global");
var _field_types_provider = require("../../../containers/field_types_provider");
var _inspector = require("../../../containers/inspector");
var _use_column_settings = require("../hooks/use_column_settings");
var _filters = require("../containers/filters");
var _update_status = require("../../../components/update_status");
var _query_bar = require("../../query_bar/components/query_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndicatorsPageProviders = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_filters.IndicatorsFilters, null, /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, null, /*#__PURE__*/_react.default.createElement(_inspector.InspectorProvider, null, /*#__PURE__*/_react.default.createElement(_block_list_provider.BlockListProvider, null, children))));
const IndicatorsPageContent = () => {
  const {
    blockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const {
    browserFields,
    indexPattern,
    sourcererDataView
  } = (0, _use_sourcerer_data_view.useSourcererDataView)();
  const columnSettings = (0, _use_column_settings.useColumnSettings)();
  const {
    timeRange,
    filters,
    filterQuery
  } = (0, _use_filters.useFilters)();
  const {
    indicatorCount,
    indicators,
    onChangeItemsPerPage,
    onChangePage,
    pagination,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    dataUpdatedAt,
    query: indicatorListQuery
  } = (0, _use_indicators.useIndicators)({
    filters,
    filterQuery,
    timeRange,
    sorting: columnSettings.sorting.columns
  });
  const {
    dateRange,
    series,
    selectedField,
    onFieldChange,
    isLoading: isLoadingAggregatedIndicators,
    isFetching: isFetchingAggregatedIndicators,
    query: indicatorChartQuery
  } = (0, _use_aggregated_indicators.useAggregatedIndicators)({
    timeRange,
    filters,
    filterQuery
  });
  return /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, null, /*#__PURE__*/_react.default.createElement(_layout.DefaultPageLayout, {
    pageTitle: "Indicators",
    subHeader: /*#__PURE__*/_react.default.createElement(_update_status.UpdateStatus, {
      isUpdating: isFetchingIndicators,
      updatedAt: dataUpdatedAt
    })
  }, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBar, {
    queries: [indicatorChartQuery, indicatorListQuery],
    sourcererDataView: sourcererDataView
  })), /*#__PURE__*/_react.default.createElement(_wrapper.IndicatorsBarChartWrapper, {
    dateRange: dateRange,
    series: series,
    timeRange: timeRange,
    indexPattern: indexPattern,
    field: selectedField,
    onFieldChange: onFieldChange,
    isFetching: isFetchingAggregatedIndicators,
    isLoading: isLoadingAggregatedIndicators
  }), /*#__PURE__*/_react.default.createElement(_table.IndicatorsTable, {
    browserFields: browserFields,
    indexPattern: indexPattern,
    columnSettings: columnSettings,
    pagination: pagination,
    indicatorCount: indicatorCount,
    indicators: indicators,
    isLoading: isLoadingIndicators,
    isFetching: isFetchingIndicators,
    onChangeItemsPerPage: onChangeItemsPerPage,
    onChangePage: onChangePage
  }), blockListIndicatorValue && /*#__PURE__*/_react.default.createElement(_flyout.BlockListFlyout, {
    indicatorFileHash: blockListIndicatorValue
  })));
};
const IndicatorsPage = () => /*#__PURE__*/_react.default.createElement(IndicatorsPageProviders, null, /*#__PURE__*/_react.default.createElement(IndicatorsPageContent, null));
exports.IndicatorsPage = IndicatorsPage;