"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsBarChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _legend_action = require("./legend_action");
var _dates = require("../../../../utils/dates");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'tiIndicator';
const DEFAULT_CHART_HEIGHT = '200px';
const DEFAULT_CHART_WIDTH = '100%';
const DEFAULT_LEGEND_SIZE = 200;
/**
 * Displays a barchart of aggregated indicators using the @elastic/charts library.
 */
const IndicatorsBarChart = ({
  indicators,
  dateRange,
  field,
  height = DEFAULT_CHART_HEIGHT
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: DEFAULT_CHART_WIDTH,
      height
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings
  // TODO connect to charts.theme service see src/plugins/charts/public/services/theme/README.md
  , {
    baseTheme: _charts.LEGACY_LIGHT_THEME,
    showLegend: true,
    legendPosition: _charts.Position.Right,
    legendSize: DEFAULT_LEGEND_SIZE,
    legendAction: ({
      label
    }) => /*#__PURE__*/_react.default.createElement(_legend_action.IndicatorBarchartLegendAction, {
      field: field,
      data: label
    }),
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `${ID}TimeAxis`,
    position: _charts.Position.Bottom,
    labelFormat: (0, _dates.barChartTimeAxisLabelFormatter)(dateRange)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `${ID}IndicatorAxis`,
    position: _charts.Position.Left
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: `${ID}BarChart`,
    name: "Indicators",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    stackAccessors: ['x'],
    splitSeriesAccessors: ['g'],
    data: indicators
  })));
};
exports.IndicatorsBarChart = IndicatorsBarChart;