"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiSettings = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getUiSettings = () => ({
  [_esqlUtils.ENABLE_ESQL]: {
    name: _i18n.i18n.translate('textBasedLanguages.advancedSettings.enableESQLTitle', {
      defaultMessage: 'Enable ES|QL'
    }),
    value: true,
    description: _i18n.i18n.translate('textBasedLanguages.advancedSettings.enableESQLDescription', {
      defaultMessage: 'This setting enables ES|QL in Kibana. By switching it off you will hide the ES|QL user interface from various applications. However, users will be able to access existing ES|QL saved searches, visualizations, etc. If you have feedback on this experience please reach out to us on {link}',
      values: {
        link: `<a href="https://ela.st/esql-feedback" target="_blank" rel="noopener">` + _i18n.i18n.translate('textBasedLanguages.advancedSettings.enableESQL.discussLinkText', {
          defaultMessage: 'https://ela.st/esql-feedback'
        }) + '</a>'
      }
    }),
    requiresPageReload: true,
    schema: _configSchema.schema.boolean()
  }
});
exports.getUiSettings = getUiSettings;