"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTelemetryLastReported = registerTelemetryLastReported;
var _configSchema = require("@kbn/config-schema");
var _rxjs = require("rxjs");
var _routes = require("../../common/routes");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerTelemetryLastReported(router, savedObjectsInternalClient$) {
  // GET to retrieve
  const v2GetValidations = {
    response: {
      200: {
        body: () => _configSchema.schema.object({
          lastReported: _configSchema.schema.maybe(_configSchema.schema.number())
        })
      }
    }
  };
  const v2GetHandler = async (context, req, res) => {
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    const telemetrySavedObject = await (0, _saved_objects.getTelemetrySavedObject)(savedObjectsInternalClient);
    const body = {
      lastReported: telemetrySavedObject && (telemetrySavedObject === null || telemetrySavedObject === void 0 ? void 0 : telemetrySavedObject.lastReported)
    };
    return res.ok({
      body
    });
  };
  router.versioned.get({
    access: 'internal',
    path: _routes.LastReportedRoute
  })
  // Just because it used to be /v2/, we are creating identical v1 and v2.
  .addVersion({
    version: '1',
    validate: v2GetValidations
  }, v2GetHandler).addVersion({
    version: '2',
    validate: v2GetValidations
  }, v2GetHandler);

  // PUT to update
  const v2PutHandler = async (context, req, res) => {
    const savedObjectsInternalClient = await (0, _rxjs.firstValueFrom)(savedObjectsInternalClient$);
    await (0, _saved_objects.updateTelemetrySavedObject)(savedObjectsInternalClient, {
      lastReported: Date.now()
    });
    return res.ok();
  };
  router.versioned.put({
    access: 'internal',
    path: _routes.LastReportedRoute
  })
  // Just because it used to be /v2/, we are creating identical v1 and v2.
  .addVersion({
    version: '1',
    validate: false
  }, v2PutHandler).addVersion({
    version: '2',
    validate: false
  }, v2PutHandler);
}