"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserHasSeenNoticeRoute = exports.OptInRoute = exports.LastReportedRoute = exports.INTERNAL_VERSION = exports.GetOptInStatsRoutePathBasedV2 = exports.FetchTelemetryConfigRoutePathBasedV2 = exports.FetchTelemetryConfigRoute = exports.FetchSnapshotTelemetry = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BASE_INTERNAL_PATH = '/internal/telemetry';
const INTERNAL_VERSION = exports.INTERNAL_VERSION = {
  version: '2'
};

/**
 * Fetch Telemetry Config
 * @public Kept public and path-based because we know other Elastic products fetch the opt-in status via this endpoint.
 */
const FetchTelemetryConfigRoutePathBasedV2 = exports.FetchTelemetryConfigRoutePathBasedV2 = '/api/telemetry/v2/config';

/**
 * Fetch Telemetry Config
 * @internal
 */
const FetchTelemetryConfigRoute = exports.FetchTelemetryConfigRoute = `${BASE_INTERNAL_PATH}/config`;

/**
 * GET/PUT Last reported date for Snapshot telemetry
 * @internal
 */
const LastReportedRoute = exports.LastReportedRoute = `${BASE_INTERNAL_PATH}/last_reported`;

/**
 * Set user has seen notice
 * @internal
 */
const UserHasSeenNoticeRoute = exports.UserHasSeenNoticeRoute = `${BASE_INTERNAL_PATH}/userHasSeenNotice`;

/**
 * Set opt-in/out status
 * @internal
 */
const OptInRoute = exports.OptInRoute = `${BASE_INTERNAL_PATH}/optIn`;

/**
 * Fetch the Snapshot telemetry report
 * @internal
 */
const FetchSnapshotTelemetry = exports.FetchSnapshotTelemetry = `${BASE_INTERNAL_PATH}/clusters/_stats`;

/**
 * Get Opt-in stats
 * @internal
 * @deprecated
 */
const GetOptInStatsRoutePathBasedV2 = exports.GetOptInStatsRoutePathBasedV2 = '/api/telemetry/v2/clusters/_opt_in_stats';