"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.taskSchemaV1 = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const taskSchemaV1 = exports.taskSchemaV1 = _configSchema.schema.object({
  taskType: _configSchema.schema.string(),
  scheduledAt: _configSchema.schema.string(),
  startedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
  retryAt: _configSchema.schema.nullable(_configSchema.schema.string()),
  runAt: _configSchema.schema.string(),
  schedule: _configSchema.schema.maybe(_configSchema.schema.object({
    interval: _configSchema.schema.duration()
  })),
  params: _configSchema.schema.string(),
  state: _configSchema.schema.string(),
  stateVersion: _configSchema.schema.maybe(_configSchema.schema.number()),
  traceparent: _configSchema.schema.string(),
  user: _configSchema.schema.maybe(_configSchema.schema.string()),
  scope: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  ownerId: _configSchema.schema.nullable(_configSchema.schema.string()),
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeoutOverride: _configSchema.schema.maybe(_configSchema.schema.string()),
  attempts: _configSchema.schema.number(),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('idle'), _configSchema.schema.literal('claiming'), _configSchema.schema.literal('running'), _configSchema.schema.literal('failed'), _configSchema.schema.literal('unrecognized'), _configSchema.schema.literal('dead_letter')]),
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});