"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskClaimMetricsAggregator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _result_type = require("../lib/result_type");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HDR_HISTOGRAM_MAX = 30000; // 30 seconds
const HDR_HISTOGRAM_BUCKET_SIZE = 100; // 100 millis
var TaskClaimKeys = /*#__PURE__*/function (TaskClaimKeys) {
  TaskClaimKeys["SUCCESS"] = "success";
  TaskClaimKeys["TOTAL"] = "total";
  return TaskClaimKeys;
}(TaskClaimKeys || {});
class TaskClaimMetricsAggregator {
  constructor() {
    (0, _defineProperty2.default)(this, "counter", new _lib.MetricCounterService(Object.values(TaskClaimKeys)));
    (0, _defineProperty2.default)(this, "durationHistogram", new _lib.SimpleHistogram(HDR_HISTOGRAM_MAX, HDR_HISTOGRAM_BUCKET_SIZE));
  }
  initialMetric() {
    return {
      ...this.counter.initialMetrics(),
      duration: {
        counts: [],
        values: []
      },
      duration_values: []
    };
  }
  collect() {
    return {
      ...this.counter.collect(),
      duration: this.durationHistogram.serialize(),
      duration_values: this.durationHistogram.getAllValues()
    };
  }
  reset() {
    this.counter.reset();
    this.durationHistogram.reset();
  }
  processTaskLifecycleEvent(taskEvent) {
    const success = (0, _result_type.isOk)(taskEvent.event);
    if (success) {
      this.counter.increment(TaskClaimKeys.SUCCESS);
    }
    this.counter.increment(TaskClaimKeys.TOTAL);
    if (taskEvent.timing) {
      const durationInMs = taskEvent.timing.stop - taskEvent.timing.start;
      this.durationHistogram.record(durationInMs);
    }
  }
}
exports.TaskClaimMetricsAggregator = TaskClaimMetricsAggregator;