"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsRouteWrapper = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _common = require("@kbn/spaces-plugin/common");
var _lodash = require("lodash");
var _lib = require("./lib");
var _check_has_privilege = require("./synthetics_service/authentication/check_has_privilege");
var _constants = require("../common/constants");
var _service_api_key = require("./saved_objects/service_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsRouteWrapper = (uptimeRoute, server, syntheticsMonitorClient) => {
  var _uptimeRoute$options;
  return {
    ...uptimeRoute,
    options: {
      tags: ['access:uptime-read', ...(uptimeRoute !== null && uptimeRoute !== void 0 && uptimeRoute.writeAccess ? ['access:uptime-write'] : [])],
      ...((_uptimeRoute$options = uptimeRoute.options) !== null && _uptimeRoute$options !== void 0 ? _uptimeRoute$options : {})
    },
    handler: async (context, request, response) => {
      var _server$spaces$spaces, _server$spaces;
      const {
        elasticsearch,
        savedObjects,
        uiSettings
      } = await context.core;
      const {
        client: esClient
      } = elasticsearch;
      const savedObjectsClient = savedObjects.getClient({
        includedHiddenTypes: [_service_api_key.syntheticsServiceApiKey.name]
      });

      // specifically needed for the synthetics service api key generation
      server.authSavedObjectsClient = savedObjectsClient;
      const uptimeEsClient = new _lib.UptimeEsClient(savedObjectsClient, esClient.asCurrentUser, {
        request,
        uiSettings,
        isDev: Boolean(server.isDev) && !(0, _lib.isTestUser)(server),
        heartbeatIndices: _constants.SYNTHETICS_INDEX_PATTERN
      });
      server.uptimeEsClient = uptimeEsClient;
      const spaceId = (_server$spaces$spaces = (_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
      try {
        const res = await uptimeRoute.handler({
          uptimeEsClient,
          savedObjectsClient,
          context,
          request,
          response,
          server,
          spaceId,
          syntheticsMonitorClient
        });
        if (res instanceof _coreHttpRouterServerInternal.KibanaResponse) {
          return res;
        }
        const inspectData = await uptimeEsClient.getInspectData(uptimeRoute.path);
        if (Array.isArray(res)) {
          if ((0, _lodash.isEmpty)(inspectData)) {
            return response.ok({
              body: res
            });
          } else {
            return response.ok({
              body: {
                result: res,
                ...inspectData
              }
            });
          }
        }
        return response.ok({
          body: {
            ...res,
            ...(await uptimeEsClient.getInspectData(uptimeRoute.path))
          }
        });
      } catch (e) {
        if (e.statusCode === 403) {
          const privileges = await (0, _check_has_privilege.checkIndicesReadPrivileges)(uptimeEsClient);
          if (!privileges.has_all_requested) {
            return response.forbidden({
              body: {
                message: 'MissingIndicesPrivileges: You do not have permission to read from the synthetics-* indices. Please contact your administrator.'
              }
            });
          }
        }
        throw e;
      }
    }
  };
};
exports.syntheticsRouteWrapper = syntheticsRouteWrapper;