"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsMonitorSavedObjectType = exports.getDecryptedMonitor = exports.SYNTHETICS_MONITOR_ENCRYPTED_TYPE = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("../../common/types/saved_objects");
var _monitor_management = require("../../common/constants/monitor_management");
var _monitors = require("./migrations/monitors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const attributesToIncludeInAAD = new Set([_monitor_management.ConfigKey.APM_SERVICE_NAME, _monitor_management.ConfigKey.CUSTOM_HEARTBEAT_ID, _monitor_management.ConfigKey.CONFIG_ID, _monitor_management.ConfigKey.CONFIG_HASH, _monitor_management.ConfigKey.ENABLED, _monitor_management.ConfigKey.FORM_MONITOR_TYPE, _monitor_management.ConfigKey.HOSTS, _monitor_management.ConfigKey.IGNORE_HTTPS_ERRORS, _monitor_management.ConfigKey.MONITOR_SOURCE_TYPE, _monitor_management.ConfigKey.JOURNEY_FILTERS_MATCH, _monitor_management.ConfigKey.JOURNEY_FILTERS_TAGS, _monitor_management.ConfigKey.JOURNEY_ID, _monitor_management.ConfigKey.MAX_REDIRECTS, _monitor_management.ConfigKey.MODE, _monitor_management.ConfigKey.MONITOR_TYPE, _monitor_management.ConfigKey.NAME, _monitor_management.ConfigKey.NAMESPACE, _monitor_management.ConfigKey.LOCATIONS, _monitor_management.ConfigKey.PLAYWRIGHT_OPTIONS, _monitor_management.ConfigKey.ORIGINAL_SPACE, _monitor_management.ConfigKey.PORT, _monitor_management.ConfigKey.PROXY_URL, _monitor_management.ConfigKey.PROXY_USE_LOCAL_RESOLVER, _monitor_management.ConfigKey.RESPONSE_BODY_INDEX, _monitor_management.ConfigKey.RESPONSE_HEADERS_INDEX, _monitor_management.ConfigKey.RESPONSE_BODY_MAX_BYTES, _monitor_management.ConfigKey.RESPONSE_STATUS_CHECK, _monitor_management.ConfigKey.REQUEST_METHOD_CHECK, _monitor_management.ConfigKey.REVISION, _monitor_management.ConfigKey.SCHEDULE, _monitor_management.ConfigKey.SCREENSHOTS, _monitor_management.ConfigKey.IPV4, _monitor_management.ConfigKey.IPV6, _monitor_management.ConfigKey.PROJECT_ID, _monitor_management.ConfigKey.TEXT_ASSERTION, _monitor_management.ConfigKey.TLS_CERTIFICATE_AUTHORITIES, _monitor_management.ConfigKey.TLS_CERTIFICATE, _monitor_management.ConfigKey.TLS_VERIFICATION_MODE, _monitor_management.ConfigKey.TLS_VERSION, _monitor_management.ConfigKey.TAGS, _monitor_management.ConfigKey.TIMEOUT, _monitor_management.ConfigKey.THROTTLING_CONFIG, _monitor_management.ConfigKey.URLS, _monitor_management.ConfigKey.WAIT, _monitor_management.ConfigKey.MONITOR_QUERY_ID]);
const LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = exports.LEGACY_SYNTHETICS_MONITOR_ENCRYPTED_TYPE = {
  type: _saved_objects.syntheticsMonitorType,
  attributesToEncrypt: new Set(['secrets',
  /* adding secretKeys to the list of attributes to encrypt ensures
   * that secrets are never stored on the resulting saved object,
   * even in the presence of developer error.
   *
   * In practice, all secrets should be stored as a single JSON
   * payload on the `secrets` key. This ensures performant decryption. */
  ..._monitor_management.secretKeys]),
  attributesToIncludeInAAD: new Set([_monitor_management.LegacyConfigKey.SOURCE_ZIP_URL, _monitor_management.LegacyConfigKey.SOURCE_ZIP_USERNAME, _monitor_management.LegacyConfigKey.SOURCE_ZIP_PASSWORD, _monitor_management.LegacyConfigKey.SOURCE_ZIP_FOLDER, _monitor_management.LegacyConfigKey.SOURCE_ZIP_PROXY_URL, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_CERTIFICATE_AUTHORITIES, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_CERTIFICATE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_KEY, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_KEY_PASSPHRASE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_VERIFICATION_MODE, _monitor_management.LegacyConfigKey.ZIP_URL_TLS_VERSION, _monitor_management.LegacyConfigKey.THROTTLING_CONFIG, _monitor_management.LegacyConfigKey.IS_THROTTLING_ENABLED, _monitor_management.LegacyConfigKey.DOWNLOAD_SPEED, _monitor_management.LegacyConfigKey.UPLOAD_SPEED, _monitor_management.LegacyConfigKey.LATENCY, ...attributesToIncludeInAAD])
};
const SYNTHETICS_MONITOR_ENCRYPTED_TYPE = exports.SYNTHETICS_MONITOR_ENCRYPTED_TYPE = {
  type: _saved_objects.syntheticsMonitorType,
  attributesToEncrypt: new Set(['secrets',
  /* adding secretKeys to the list of attributes to encrypt ensures
   * that secrets are never stored on the resulting saved object,
   * even in the presence of developer error.
   *
   * In practice, all secrets should be stored as a single JSON
   * payload on the `secrets` key. This ensures performant decryption. */
  ..._monitor_management.secretKeys]),
  attributesToIncludeInAAD
};
const getSyntheticsMonitorSavedObjectType = encryptedSavedObjects => {
  return {
    name: _saved_objects.syntheticsMonitorType,
    hidden: false,
    namespaceType: 'single',
    migrations: {
      '8.6.0': _monitors.monitorMigrations['8.6.0'](encryptedSavedObjects),
      '8.8.0': _monitors.monitorMigrations['8.8.0'](encryptedSavedObjects),
      '8.9.0': _monitors.monitorMigrations['8.9.0'](encryptedSavedObjects)
    },
    mappings: {
      dynamic: false,
      properties: {
        name: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword',
              ignore_above: 256,
              normalizer: 'lowercase'
            }
          }
        },
        type: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword',
              ignore_above: 256
            }
          }
        },
        urls: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword',
              ignore_above: 256
            }
          }
        },
        hosts: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword',
              ignore_above: 256
            }
          }
        },
        journey_id: {
          type: 'keyword'
        },
        project_id: {
          type: 'keyword',
          fields: {
            text: {
              type: 'text'
            }
          }
        },
        origin: {
          type: 'keyword'
        },
        hash: {
          type: 'keyword'
        },
        locations: {
          properties: {
            id: {
              type: 'keyword',
              ignore_above: 256,
              fields: {
                text: {
                  type: 'text'
                }
              }
            },
            label: {
              type: 'text'
            }
          }
        },
        custom_heartbeat_id: {
          type: 'keyword'
        },
        id: {
          type: 'keyword'
        },
        config_id: {
          type: 'keyword'
        },
        tags: {
          type: 'keyword',
          fields: {
            text: {
              type: 'text'
            }
          }
        },
        schedule: {
          properties: {
            number: {
              type: 'integer'
            }
          }
        },
        enabled: {
          type: 'boolean'
        },
        alert: {
          properties: {
            status: {
              properties: {
                enabled: {
                  type: 'boolean'
                }
              }
            },
            tls: {
              properties: {
                enabled: {
                  type: 'boolean'
                }
              }
            }
          }
        },
        throttling: {
          properties: {
            label: {
              type: 'keyword'
            }
          }
        }
      }
    },
    management: {
      importableAndExportable: false,
      icon: 'uptimeApp',
      getTitle: savedObject => savedObject.attributes.name + ' - ' + _i18n.i18n.translate('xpack.synthetics.syntheticsMonitors.label', {
        defaultMessage: 'Synthetics - Monitor'
      })
    },
    modelVersions: {
      '1': {
        changes: [{
          type: 'mappings_addition',
          addedMappings: {
            config_id: {
              type: 'keyword'
            }
          }
        }]
      }
    }
  };
};
exports.getSyntheticsMonitorSavedObjectType = getSyntheticsMonitorSavedObjectType;
const getDecryptedMonitor = async (server, monitorId, spaceId) => {
  const encryptedClient = server.encryptedSavedObjects.getClient();
  return await encryptedClient.getDecryptedAsInternalUser(_saved_objects.syntheticsMonitorType, monitorId, {
    namespace: spaceId
  });
};
exports.getDecryptedMonitor = getDecryptedMonitor;