"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitorsByLocation = exports.getLocationMonitors = void 0;
var _constants = require("@kbn/spaces-plugin/common/constants");
var _common = require("../../common");
var _constants2 = require("../../../../common/constants");
var _saved_objects = require("../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggs = {
  locations: {
    terms: {
      field: `${_saved_objects.monitorAttributes}.locations.id`,
      size: 10000
    }
  }
};
const getLocationMonitors = () => ({
  method: 'GET',
  path: _constants2.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_MONITORS,
  validate: {},
  handler: async ({
    server
  }) => {
    return await getMonitorsByLocation(server);
  }
});
exports.getLocationMonitors = getLocationMonitors;
const getMonitorsByLocation = async (server, locationId) => {
  var _locationMonitors$agg, _locationMonitors$agg2;
  const soClient = server.coreStart.savedObjects.createInternalRepository();
  const locationFilter = (0, _common.getKqlFilter)({
    field: 'locations.id',
    values: locationId
  });
  const locationMonitors = await soClient.find({
    type: _saved_objects.syntheticsMonitorType,
    perPage: 0,
    aggs,
    filter: locationFilter,
    namespaces: [_constants.ALL_SPACES_ID]
  });
  return (_locationMonitors$agg = (_locationMonitors$agg2 = locationMonitors.aggregations) === null || _locationMonitors$agg2 === void 0 ? void 0 : _locationMonitors$agg2.locations.buckets.map(({
    key: id,
    doc_count: count
  }) => ({
    id,
    count
  }))) !== null && _locationMonitors$agg !== void 0 ? _locationMonitors$agg : [];
};
exports.getMonitorsByLocation = getMonitorsByLocation;