"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deletePrivateLocationRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var _get_location_monitors = require("./get_location_monitors");
var _get_private_locations = require("./get_private_locations");
var _constants = require("../../../../common/constants");
var _private_locations = require("../../../../common/saved_objects/private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deletePrivateLocationRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS + '/{locationId}',
  validate: {},
  validation: {
    request: {
      params: _configSchema.schema.object({
        locationId: _configSchema.schema.string({
          minLength: 1,
          maxLength: 1024
        })
      })
    }
  },
  handler: async ({
    response,
    savedObjectsClient,
    syntheticsMonitorClient,
    request,
    server
  }) => {
    const {
      locationId
    } = request.params;
    const {
      locations
    } = await (0, _get_private_locations.getPrivateLocationsAndAgentPolicies)(savedObjectsClient, syntheticsMonitorClient);
    if (!locations.find(loc => loc.id === locationId)) {
      return response.badRequest({
        body: {
          message: `Private location with id ${locationId} does not exist.`
        }
      });
    }
    const monitors = await (0, _get_location_monitors.getMonitorsByLocation)(server, locationId);
    if (!(0, _lodash.isEmpty)(monitors)) {
      var _monitors$find;
      const count = (_monitors$find = monitors.find(monitor => monitor.id === locationId)) === null || _monitors$find === void 0 ? void 0 : _monitors$find.count;
      return response.badRequest({
        body: {
          message: `Private location with id ${locationId} cannot be deleted because it is used by ${count} monitor(s).`
        }
      });
    }
    const remainingLocations = locations.filter(loc => loc.id !== locationId);
    await savedObjectsClient.create(_private_locations.privateLocationsSavedObjectName, {
      locations: remainingLocations
    }, {
      id: _private_locations.privateLocationsSavedObjectId,
      overwrite: true
    });
    return;
  }
});
exports.deletePrivateLocationRoute = deletePrivateLocationRoute;