"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../../../../common/types/saved_objects");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RequestParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string())
});
const getSyntheticsParamsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.PARAMS + '/{id?}',
  validate: {},
  validation: {
    request: {
      params: RequestParamsSchema
    }
  },
  handler: async ({
    savedObjectsClient,
    request,
    response,
    server,
    spaceId
  }) => {
    try {
      var _await$server$coreSta, _server$coreStart;
      const {
        id: paramId
      } = request.params;
      const encryptedSavedObjectsClient = server.encryptedSavedObjects.getClient();
      const canSave = (_await$server$coreSta = (await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
        capabilityPath: 'uptime.*'
      }))).uptime.save) !== null && _await$server$coreSta !== void 0 ? _await$server$coreSta : false;
      if (canSave) {
        if (paramId) {
          const savedObject = await encryptedSavedObjectsClient.getDecryptedAsInternalUser(_saved_objects.syntheticsParamType, paramId, {
            namespace: spaceId
          });
          return toClientResponse(savedObject);
        }
        const finder = await encryptedSavedObjectsClient.createPointInTimeFinderDecryptedAsInternalUser({
          type: _saved_objects.syntheticsParamType,
          perPage: 1000,
          namespaces: [spaceId]
        });
        const hits = [];
        for await (const result of finder.find()) {
          hits.push(...result.saved_objects);
        }
        return hits.map(savedObject => toClientResponse(savedObject));
      } else {
        if (paramId) {
          const savedObject = await savedObjectsClient.get(_saved_objects.syntheticsParamType, paramId);
          return toClientResponse(savedObject);
        }
        const data = await savedObjectsClient.find({
          type: _saved_objects.syntheticsParamType,
          perPage: 10000
        });
        return data.saved_objects.map(savedObject => toClientResponse(savedObject));
      }
    } catch (error) {
      var _error$output;
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        return response.notFound({
          body: {
            message: `Kibana space '${spaceId}' does not exist`
          }
        });
      }
      throw error;
    }
  }
});
exports.getSyntheticsParamsRoute = getSyntheticsParamsRoute;
const toClientResponse = savedObject => {
  const {
    id,
    attributes,
    namespaces
  } = savedObject;
  return {
    ...attributes,
    id,
    namespaces
  };
};