"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJourneyRoute = exports.createJourneyFailedStepsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_journey_failed_steps = require("../../legacy_uptime/lib/requests/get_journey_failed_steps");
var _constants = require("../../../common/constants");
var _get_journey_details = require("../../queries/get_journey_details");
var _get_journey_steps = require("../../legacy_uptime/lib/requests/get_journey_steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJourneyRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY,
  validate: {
    params: _configSchema.schema.object({
      checkGroup: _configSchema.schema.string()
    })
  },
  handler: async ({
    uptimeEsClient,
    request,
    response
  }) => {
    const {
      checkGroup
    } = request.params;
    const [steps, details] = await Promise.all([(0, _get_journey_steps.getJourneySteps)({
      uptimeEsClient,
      checkGroup
    }), (0, _get_journey_details.getJourneyDetails)({
      uptimeEsClient,
      checkGroup
    })]);
    return {
      steps,
      details,
      checkGroup
    };
  }
});
exports.createJourneyRoute = createJourneyRoute;
const createJourneyFailedStepsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY_FAILED_STEPS,
  validate: {
    query: _configSchema.schema.object({
      checkGroups: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  handler: async ({
    uptimeEsClient,
    request,
    response
  }) => {
    const {
      checkGroups
    } = request.query;
    try {
      const result = await (0, _get_journey_failed_steps.getJourneyFailedSteps)({
        uptimeEsClient,
        checkGroups
      });
      return {
        checkGroups,
        steps: result
      };
    } catch (e) {
      return response.customError({
        statusCode: 500,
        body: e
      });
    }
  }
});
exports.createJourneyFailedStepsRoute = createJourneyFailedStepsRoute;