"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePermissions = exports.addSyntheticsProjectMonitorRoute = exports.REQUEST_TOO_LARGE = exports.ELASTIC_MANAGED_LOCATIONS_DISABLED = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("../../../common/constants");
var _project_monitor_formatter = require("../../synthetics_service/project_monitor/project_monitor_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PAYLOAD_SIZE = 1048576 * 50; // 20MiB

const addSyntheticsProjectMonitorRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS_PROJECT_UPDATE,
  validate: {
    params: _configSchema.schema.object({
      projectName: _configSchema.schema.string()
    }),
    body: _configSchema.schema.object({
      monitors: _configSchema.schema.arrayOf(_configSchema.schema.any())
    })
  },
  options: {
    body: {
      maxBytes: MAX_PAYLOAD_SIZE
    }
  },
  handler: async routeContext => {
    var _request$body;
    const {
      request,
      response,
      server
    } = routeContext;
    const {
      projectName
    } = request.params;
    const decodedProjectName = decodeURI(projectName);
    const monitors = ((_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.monitors) || [];
    if (monitors.length > 250) {
      return response.badRequest({
        body: {
          message: REQUEST_TOO_LARGE
        }
      });
    }
    try {
      var _await$server$spaces$, _server$spaces;
      const {
        id: spaceId
      } = (_await$server$spaces$ = await ((_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.getActiveSpace(request))) !== null && _await$server$spaces$ !== void 0 ? _await$server$spaces$ : {
        id: _common.DEFAULT_SPACE_ID
      };
      const permissionError = await validatePermissions(routeContext, monitors);
      if (permissionError) {
        return response.forbidden({
          body: {
            message: permissionError
          }
        });
      }
      const encryptedSavedObjectsClient = server.encryptedSavedObjects.getClient();
      const pushMonitorFormatter = new _project_monitor_formatter.ProjectMonitorFormatter({
        routeContext,
        projectId: decodedProjectName,
        spaceId,
        encryptedSavedObjectsClient,
        monitors
      });
      await pushMonitorFormatter.configureAllProjectMonitors();
      return {
        createdMonitors: pushMonitorFormatter.createdMonitors,
        updatedMonitors: pushMonitorFormatter.updatedMonitors,
        failedMonitors: pushMonitorFormatter.failedMonitors
      };
    } catch (error) {
      var _error$output;
      server.logger.error(`Error adding monitors to project ${decodedProjectName}`);
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        var _server$spaces$spaces, _server$spaces2;
        const spaceId = (_server$spaces$spaces = (_server$spaces2 = server.spaces) === null || _server$spaces2 === void 0 ? void 0 : _server$spaces2.spacesService.getSpaceId(request)) !== null && _server$spaces$spaces !== void 0 ? _server$spaces$spaces : _common.DEFAULT_SPACE_ID;
        return response.notFound({
          body: {
            message: `Kibana space '${spaceId}' does not exist`
          }
        });
      }
      throw error;
    }
  }
});
exports.addSyntheticsProjectMonitorRoute = addSyntheticsProjectMonitorRoute;
const REQUEST_TOO_LARGE = exports.REQUEST_TOO_LARGE = _i18n.i18n.translate('xpack.synthetics.server.project.delete.toolarge', {
  defaultMessage: 'Delete request payload is too large. Please send a max of 250 monitors to delete per request'
});
const validatePermissions = async ({
  server,
  response,
  request
}, projectMonitors) => {
  var _Boolean, _server$coreStart;
  const hasPublicLocations = projectMonitors.some(({
    locations
  }) => (locations !== null && locations !== void 0 ? locations : []).length > 0);
  if (!hasPublicLocations) {
    return;
  }
  const elasticManagedLocationsEnabled = (_Boolean = Boolean((await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
    capabilityPath: 'uptime.*'
  }))).uptime.elasticManagedLocationsEnabled)) !== null && _Boolean !== void 0 ? _Boolean : true;
  if (!elasticManagedLocationsEnabled) {
    return ELASTIC_MANAGED_LOCATIONS_DISABLED;
  }
};
exports.validatePermissions = validatePermissions;
const ELASTIC_MANAGED_LOCATIONS_DISABLED = exports.ELASTIC_MANAGED_LOCATIONS_DISABLED = _i18n.i18n.translate('xpack.synthetics.noAccess.publicLocations', {
  defaultMessage: "You don't have permission to use Elastic managed global locations. Please contact your Kibana administrator."
});