"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMonitorLocations = exports.getPrivateLocationsForMonitor = void 0;
var _get_private_locations = require("../../../synthetics_service/get_private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivateLocationsForMonitor = async (soClient, normalizedMonitor) => {
  const {
    locations
  } = normalizedMonitor;
  const hasPrivateLocation = locations.filter(location => !location.isServiceManaged);
  if (hasPrivateLocation.length === 0) {
    return [];
  }
  return await (0, _get_private_locations.getPrivateLocations)(soClient);
};
exports.getPrivateLocationsForMonitor = getPrivateLocationsForMonitor;
const parseMonitorLocations = (monitorPayload, prevLocations, ui = false) => {
  var _locations$filter, _ref;
  const {
    locations,
    private_locations: privateLocations
  } = monitorPayload;
  let locs = locations === null || locations === void 0 ? void 0 : locations.filter(loc => typeof loc === 'string' || loc.isServiceManaged).map(loc => typeof loc === 'string' ? loc : loc.id);
  const extractPvtLocs = (_locations$filter = locations === null || locations === void 0 ? void 0 : locations.filter(loc => typeof loc !== 'string' && !loc.isServiceManaged)) !== null && _locations$filter !== void 0 ? _locations$filter : [];
  let pvtLocs = (_ref = [...(privateLocations !== null && privateLocations !== void 0 ? privateLocations : []), ...extractPvtLocs]) === null || _ref === void 0 ? void 0 : _ref.map(loc => typeof loc === 'string' ? loc : loc.id);
  if (ui && !privateLocations && !locations && prevLocations) {
    locs = prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id);
    pvtLocs = prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id);
  } else {
    if (prevLocations && !ui) {
      if (!locations && !privateLocations) {
        locs = prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id);
        pvtLocs = prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id);
      } else {
        if (!privateLocations) {
          var _pvtLocs;
          pvtLocs = [...((_pvtLocs = pvtLocs) !== null && _pvtLocs !== void 0 ? _pvtLocs : []), ...prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id)];
          if ((locations === null || locations === void 0 ? void 0 : locations.length) === 0) {
            locs = [];
          } else {
            var _locs;
            locs = [...((_locs = locs) !== null && _locs !== void 0 ? _locs : []), ...prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id)];
          }
        }
        if (!locations) {
          var _locs2;
          locs = [...((_locs2 = locs) !== null && _locs2 !== void 0 ? _locs2 : []), ...prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id)];
          if ((privateLocations === null || privateLocations === void 0 ? void 0 : privateLocations.length) === 0) {
            pvtLocs = [];
          } else {
            var _pvtLocs2;
            pvtLocs = [...((_pvtLocs2 = pvtLocs) !== null && _pvtLocs2 !== void 0 ? _pvtLocs2 : []), ...prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id)];
          }
        }
      }
    }
  }
  return {
    locations: Array.from(new Set(locs)),
    privateLocations: Array.from(new Set(pvtLocs))
  };
};
exports.parseMonitorLocations = parseMonitorLocations;