"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeFeature = void 0;
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("../common/types/saved_objects");
var _synthetics_alerts = require("../common/constants/synthetics_alerts");
var _private_locations = require("../common/saved_objects/private_locations");
var _plugin = require("../common/constants/plugin");
var _uptime_settings = require("./saved_objects/uptime_settings");
var _service_api_key = require("./saved_objects/service_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPTIME_RULE_TYPES = ['xpack.uptime.alerts.tls', 'xpack.uptime.alerts.tlsCertificate', 'xpack.uptime.alerts.monitorStatus', 'xpack.uptime.alerts.durationAnomaly'];
const ruleTypes = [...UPTIME_RULE_TYPES, ..._synthetics_alerts.SYNTHETICS_RULE_TYPES];
const elasticManagedLocationsEnabledPrivilege = {
  groupType: 'independent',
  privileges: [{
    id: 'elastic_managed_locations_enabled',
    name: _i18n.i18n.translate('xpack.synthetics.features.elasticManagedLocations', {
      defaultMessage: 'Elastic managed locations enabled'
    }),
    includeIn: 'all',
    savedObject: {
      all: [],
      read: []
    },
    ui: ['elasticManagedLocationsEnabled']
  }]
};
const uptimeFeature = exports.uptimeFeature = {
  id: _plugin.PLUGIN.ID,
  name: _plugin.PLUGIN.NAME,
  order: 1000,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  app: ['uptime', 'kibana', 'synthetics'],
  catalogue: ['uptime'],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: ruleTypes,
  privileges: {
    all: {
      app: ['uptime', 'kibana', 'synthetics'],
      catalogue: ['uptime'],
      api: ['uptime-read', 'uptime-write', 'lists-all', 'rac'],
      savedObject: {
        all: [_uptime_settings.settingsObjectType, _saved_objects.syntheticsMonitorType, _service_api_key.syntheticsApiKeyObjectType, _private_locations.privateLocationsSavedObjectName, _saved_objects.syntheticsParamType],
        read: []
      },
      alerting: {
        rule: {
          all: ruleTypes
        },
        alert: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['save', 'configureSettings', 'show', 'alerting:save']
    },
    read: {
      app: ['uptime', 'kibana', 'synthetics'],
      catalogue: ['uptime'],
      api: ['uptime-read', 'lists-read', 'rac'],
      savedObject: {
        all: [],
        read: [_saved_objects.syntheticsParamType, _uptime_settings.settingsObjectType, _saved_objects.syntheticsMonitorType, _service_api_key.syntheticsApiKeyObjectType, _private_locations.privateLocationsSavedObjectName]
      },
      alerting: {
        rule: {
          read: ruleTypes
        },
        alert: {
          read: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'alerting:save']
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.synthetics.features.app', {
      defaultMessage: 'Synthetics'
    }),
    privilegeGroups: [elasticManagedLocationsEnabledPrivilege]
  }]
};