"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _plugin = require("../common/constants/plugin");
var _ui = require("../common/constants/ui");
var _locators = require("./apps/locators");
var _kibana_services = require("./kibana_services");
var _alert_types = require("./apps/synthetics/lib/alert_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class UptimePlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "_packageInfo", void 0);
    this.initContext = initContext;
    this._packageInfo = initContext.env.packageInfo;
  }
  setup(core, plugins) {
    _locators.locators.forEach(locator => {
      plugins.share.url.locators.create(locator);
    });
    registerSyntheticsRoutesWithNavigation(core, plugins);
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];

    // Register the Synthetics UI plugin
    core.application.register({
      id: 'synthetics',
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.SYNTHETICS,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [{
        id: 'overview',
        title: this._isServerless ? _i18n.i18n.translate('xpack.synthetics.overviewPage.serverless.linkText', {
          defaultMessage: 'Overview'
        }) : _i18n.i18n.translate('xpack.synthetics.overviewPage.linkText', {
          defaultMessage: 'Monitors'
        }),
        path: '/'
      }, {
        id: 'certificates',
        title: _i18n.i18n.translate('xpack.synthetics.deepLink.certificatesPage.linkText', {
          defaultMessage: 'TLS Certificates'
        }),
        path: '/certificates'
      }],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/synthetics/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev, this._isServerless);
      }
    });
  }
  start(coreStart, pluginsStart) {
    const {
      triggersActionsUi
    } = pluginsStart;
    (0, _kibana_services.setStartServices)(coreStart);
    _alert_types.syntheticsAlertTypeInitializers.forEach(init => {
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        observabilityRuleTypeRegistry.register(alertInitializer);
      }
    });
  }
  stop() {}
  get _isServerless() {
    return this._packageInfo.buildFlavor === 'serverless';
  }
}
exports.UptimePlugin = UptimePlugin;
function registerSyntheticsRoutesWithNavigation(core, plugins) {
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.map)(([coreStart]) => {
    var _coreStart$applicatio;
    if ((_coreStart$applicatio = coreStart.application.capabilities.uptime) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.show) {
      return [{
        label: 'Synthetics',
        sortKey: 499,
        entries: [{
          label: _i18n.i18n.translate('xpack.synthetics.overview.SyntheticsHeading', {
            defaultMessage: 'Monitors'
          }),
          app: 'synthetics',
          path: _ui.OVERVIEW_ROUTE,
          matchFullPath: true,
          ignoreTrailingSlash: true,
          isNewFeature: true
        }, {
          label: _i18n.i18n.translate('xpack.synthetics.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'synthetics',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  })));
}