"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _certs = require("./certs");
var _certificates = require("./certificates/certificates");
var _global_params = require("./global_params");
var _overview_status = require("./overview_status");
var _browser_journey = require("./browser_journey");
var _alert_rules = require("./alert_rules");
var _manual_test_runs = require("./manual_test_runs");
var _settings = require("./settings");
var _elasticsearch = require("./elasticsearch");
var _private_locations = require("./private_locations");
var _network_events = require("./network_events");
var _monitor_details = require("./monitor_details");
var _ui = require("./ui");
var _synthetics_enablement = require("./synthetics_enablement");
var _monitor_list = require("./monitor_list");
var _service_locations = require("./service_locations");
var _overview = require("./overview");
var _ping_status = require("./ping_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rootReducer = exports.rootReducer = (0, _toolkit.combineReducers)({
  ui: _ui.uiReducer,
  settings: _settings.settingsReducer,
  pingStatus: _ping_status.pingStatusReducer,
  monitorList: _monitor_list.monitorListReducer,
  overview: _overview.monitorOverviewReducer,
  globalParams: _global_params.globalParamsReducer,
  networkEvents: _network_events.networkEventsReducer,
  elasticsearch: _elasticsearch.elasticsearchReducer,
  agentPolicies: _private_locations.agentPoliciesReducer,
  monitorDetails: _monitor_details.monitorDetailsReducer,
  browserJourney: _browser_journey.browserJourneyReducer,
  manualTestRuns: _manual_test_runs.manualTestRunsReducer,
  overviewStatus: _overview_status.overviewStatusReducer,
  defaultAlerting: _alert_rules.defaultAlertingReducer,
  dynamicSettings: _settings.dynamicSettingsReducer,
  serviceLocations: _service_locations.serviceLocationsReducer,
  syntheticsEnablement: _synthetics_enablement.syntheticsEnablementReducer,
  certificates: _certificates.certificatesReducer,
  certsList: _certs.certsListReducer
});