"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectPingStatusesForMonitorAndLocationAsc = exports.selectIsMonitorStatusesLoading = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getState = appState => appState.pingStatus;
const selectIsMonitorStatusesLoading = exports.selectIsMonitorStatusesLoading = (0, _reselect.createSelector)(getState, state => state.loading);
const selectPingStatusesForMonitorAndLocationAsc = (monitorId, locationId) => (0, _reselect.createSelector)([state => state.pingStatus], state => {
  var _state$pingStatuses$m, _state$pingStatuses, _state$pingStatuses$m2;
  return Object.values((_state$pingStatuses$m = state === null || state === void 0 ? void 0 : (_state$pingStatuses = state.pingStatuses) === null || _state$pingStatuses === void 0 ? void 0 : (_state$pingStatuses$m2 = _state$pingStatuses[monitorId]) === null || _state$pingStatuses$m2 === void 0 ? void 0 : _state$pingStatuses$m2[locationId]) !== null && _state$pingStatuses$m !== void 0 ? _state$pingStatuses$m : {}).sort((a, b) => Number(new Date(a.timestamp)) - Number(new Date(b.timestamp)));
});
exports.selectPingStatusesForMonitorAndLocationAsc = selectPingStatusesForMonitorAndLocationAsc;