"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorPingStatuses = void 0;
var _constants = require("../../../../../common/constants");
var _runtime_types = require("../../../../../common/runtime_types");
var _api_service = require("../../../../utils/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorPingStatuses = async ({
  monitorId,
  locationId,
  from,
  to,
  size
}) => {
  const locations = JSON.stringify([locationId]);
  const sort = 'desc';
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PING_STATUSES, {
    monitorId,
    from,
    to,
    locations,
    sort,
    size
  }, _runtime_types.PingStatusesResponseType);
};
exports.fetchMonitorPingStatuses = fetchMonitorPingStatuses;