"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchOverviewStatus = void 0;
var _constants = require("../../../../../common/constants");
var _runtime_types = require("../../../../../common/runtime_types");
var _api_service = require("../../../../utils/api_service");
var _api = require("../overview/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchOverviewStatus = async ({
  pageState,
  scopeStatusByLocation
}) => {
  const params = (0, _api.toStatusOverviewQueryArgs)(pageState);
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.OVERVIEW_STATUS, {
    ...params,
    scopeStatusByLocation
  }, _runtime_types.OverviewStatusCodec);
};
exports.fetchOverviewStatus = fetchOverviewStatus;