"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  monitorOverviewReducer: true,
  fetchMonitorOverview: true
};
Object.defineProperty(exports, "fetchMonitorOverview", {
  enumerable: true,
  get: function () {
    return _api.fetchMonitorOverview;
  }
});
exports.monitorOverviewReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _alert_config = require("../../../../../common/runtime_types/monitor_management/alert_config");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _actions2 = require("../monitor_list/actions");
var _types = require("../../components/monitor_add_edit/types");
var _models = require("./models");
Object.keys(_models).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _models[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _models[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  data: {
    total: 0,
    allMonitorIds: [],
    monitors: []
  },
  pageState: {
    perPage: 16,
    sortOrder: 'asc',
    sortField: 'status'
  },
  groupBy: {
    field: 'none',
    order: 'asc'
  },
  flyoutConfig: null,
  loading: false,
  loaded: false,
  error: null,
  isErrorPopoverOpen: null
};
const monitorOverviewReducer = exports.monitorOverviewReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.fetchMonitorOverviewAction.get, (state, action) => {
    state.loading = true;
    state.loaded = false;
  }).addCase(_actions.fetchMonitorOverviewAction.success, (state, action) => {
    state.data = action.payload;
    state.loading = false;
    state.loaded = true;
  }).addCase(_actions.fetchMonitorOverviewAction.fail, (state, action) => {
    state.loading = false;
    state.error = action.payload;
  }).addCase(_actions.setOverviewPageStateAction, (state, action) => {
    state.pageState = {
      ...state.pageState,
      ...action.payload
    };
    state.loaded = false;
  }).addCase(_actions.setOverviewGroupByAction, (state, action) => {
    state.groupBy = {
      ...state.groupBy,
      ...action.payload
    };
  }).addCase(_actions.setFlyoutConfig, (state, action) => {
    state.flyoutConfig = action.payload;
  }).addCase(_actions2.enableMonitorAlertAction.success, (state, action) => {
    const monitorObject = action.payload;
    if (!('errors' in monitorObject)) {
      const isStatusAlertEnabled = (0, _alert_config.isStatusEnabled)(monitorObject[_types.ConfigKey.ALERT_CONFIG]);
      state.data.monitors = state.data.monitors.map(monitor => {
        if (monitor.id === monitorObject[_types.ConfigKey.CONFIG_ID] || monitor.id === monitorObject[_types.ConfigKey.MONITOR_QUERY_ID]) {
          return {
            ...monitor,
            isStatusAlertEnabled
          };
        }
        return monitor;
      });
    }
  }).addCase(_actions.toggleErrorPopoverOpen, (state, action) => {
    state.isErrorPopoverOpen = action.payload;
  });
});