"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  monitorDetailsReducer: true
};
exports.monitorDetailsReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _check_pings = require("../../utils/monitor_test_result/check_pings");
var _actions = require("../monitor_list/actions");
var _actions2 = require("./actions");
Object.keys(_actions2).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions2[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions2[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  pings: {
    total: 0,
    data: [],
    loading: false
  },
  lastRun: {
    loading: false,
    loaded: false
  },
  syntheticsMonitor: null,
  syntheticsMonitorLoading: false,
  syntheticsMonitorDispatchedAt: 0,
  error: null,
  selectedLocationId: null
};
const monitorDetailsReducer = exports.monitorDetailsReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions2.setMonitorDetailsLocationAction, (state, action) => {
    state.selectedLocationId = action.payload;
  }).addCase(_actions2.getMonitorLastRunAction.get, (state, action) => {
    state.lastRun.loading = true;
    state.lastRun.loaded = false;
    if ((0, _check_pings.checkIsStalePing)(action.payload.monitorId, state.lastRun.data)) {
      state.lastRun.data = undefined;
    }
  }).addCase(_actions2.getMonitorLastRunAction.success, (state, action) => {
    state.lastRun.loading = false;
    state.lastRun.loaded = true;
    state.lastRun.data = action.payload.pings[0];
  }).addCase(_actions2.getMonitorLastRunAction.fail, (state, action) => {
    state.lastRun.loading = false;
    state.error = action.payload;
  }).addCase(_actions2.updateMonitorLastRunAction, (state, action) => {
    state.lastRun.data = action.payload.data;
  }).addCase(_actions2.resetMonitorLastRunAction, (state, action) => {
    state.lastRun.loaded = false;
  }).addCase(_actions2.getMonitorRecentPingsAction.get, (state, action) => {
    state.pings.loading = true;
    state.pings.data = state.pings.data.filter(ping => !(0, _check_pings.checkIsStalePing)(action.payload.monitorId, ping));
  }).addCase(_actions2.getMonitorRecentPingsAction.success, (state, action) => {
    state.pings.total = action.payload.total;
    state.pings.data = action.payload.pings;
    state.pings.loading = false;
  }).addCase(_actions2.getMonitorRecentPingsAction.fail, (state, action) => {
    state.error = action.payload;
    state.pings.loading = false;
  }).addCase(_actions2.getMonitorAction.get, (state, action) => {
    state.syntheticsMonitorDispatchedAt = action.meta.dispatchedAt;
    state.syntheticsMonitorLoading = true;
    state.error = null;
  }).addCase(_actions2.getMonitorAction.success, (state, action) => {
    state.syntheticsMonitor = action.payload;
    state.syntheticsMonitorLoading = false;
    state.error = null;
  }).addCase(_actions2.getMonitorAction.fail, (state, action) => {
    state.error = action.payload;
    state.syntheticsMonitorLoading = false;
  }).addCase(_actions.enableMonitorAlertAction.success, (state, action) => {
    if ('updated_at' in action.payload && state.syntheticsMonitor) {
      state.syntheticsMonitor = action.payload;
    }
  }).addCase(_actions2.setStatusFilter, (state, action) => {
    state.statusFilter = action.payload;
  });
});