"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  defaultAlertingReducer: true
};
exports.defaultAlertingReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialSettingState = {
  success: null,
  loading: false,
  error: null
};
const defaultAlertingReducer = exports.defaultAlertingReducer = (0, _toolkit.createReducer)(initialSettingState, builder => {
  builder.addCase(_actions.getDefaultAlertingAction.get, state => {
    state.loading = true;
  }).addCase(_actions.enableDefaultAlertingSilentlyAction.get, state => {
    state.loading = true;
  }).addCase(_actions.enableDefaultAlertingAction.get, state => {
    state.loading = true;
  }).addCase(_actions.enableDefaultAlertingAction.success, (state, action) => {
    state.data = action.payload;
    state.success = Boolean(action.payload);
    state.loading = false;
  }).addCase(_actions.enableDefaultAlertingAction.fail, (state, action) => {
    state.error = action.payload;
    state.loading = false;
    state.success = false;
  }).addCase(_actions.updateDefaultAlertingAction.get, state => {
    state.loading = true;
  }).addCase(_actions.updateDefaultAlertingAction.success, (state, action) => {
    state.success = Boolean(action.payload);
    state.loading = false;
  }).addCase(_actions.updateDefaultAlertingAction.fail, (state, action) => {
    state.error = action.payload;
    state.loading = false;
    state.success = false;
  });
});