"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _adapters = require("./utils/adapters");
var _constants = require("../../../common/constants");
var _synthetics_app = require("./synthetics_app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderApp(core, plugins, startPlugins, appMountParameters, isDev, isServerless) {
  var _capabilities$uptime$, _startPlugins$serverl, _startPlugins$serverl2;
  const {
    application: {
      capabilities
    },
    chrome: {
      setBadge,
      setHelpExtension
    },
    docLinks,
    http: {
      basePath
    },
    i18n,
    theme
  } = core;
  const {
    apm,
    infrastructure,
    logs
  } = (0, _adapters.getIntegratedAppAvailability)(capabilities, _constants.INTEGRATED_SOLUTIONS);
  const canSave = (_capabilities$uptime$ = capabilities.uptime.save) !== null && _capabilities$uptime$ !== void 0 ? _capabilities$uptime$ : false; // TODO: Determine for synthetics
  const darkMode = theme.getTheme().darkMode;
  const props = {
    isDev,
    plugins,
    canSave,
    core,
    i18n,
    startPlugins,
    basePath: basePath.get(),
    darkMode,
    commonlyUsedRanges: core.uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES),
    isApmAvailable: apm,
    isInfraAvailable: infrastructure,
    isLogsAvailable: logs,
    renderGlobalHelpControls: () => setHelpExtension({
      appName: _i18n.i18n.translate('xpack.synthetics.header.appName', {
        defaultMessage: 'Synthetics'
      }),
      links: [{
        linkType: 'documentation',
        href: `${docLinks.links.observability.monitorUptimeSynthetics}`
      }, {
        linkType: 'discuss',
        href: 'https://discuss.elastic.co/c/uptime' // Redirects to https://discuss.elastic.co/c/observability/synthetics/75
      }]
    }),
    setBadge,
    appMountParameters,
    isServerless,
    setBreadcrumbs: (_startPlugins$serverl = (_startPlugins$serverl2 = startPlugins.serverless) === null || _startPlugins$serverl2 === void 0 ? void 0 : _startPlugins$serverl2.setBreadcrumbs) !== null && _startPlugins$serverl !== void 0 ? _startPlugins$serverl : core.chrome.setBreadcrumbs
  };
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_synthetics_app.SyntheticsApp, props), appMountParameters.element);
  return () => {
    startPlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(appMountParameters.element);
  };
}