"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TLSAlert;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _tls_rule_ui = require("../../../components/alerts/tls_rule_ui");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function TLSAlert({
  core,
  plugins,
  ruleParams,
  setRuleParams
}) {
  _kibana_service.kibanaService.core = core;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(_tls_rule_ui.TLSRuleComponent, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams
  })));
}
module.exports = exports.default;