"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocationName = useLocationName;
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLocationName(monitor) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    locationsLoaded,
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _react.useEffect)(() => {
    if (!locationsLoaded) {
      dispatch((0, _state.getServiceLocations)());
    }
  });
  const locationId = monitor === null || monitor === void 0 ? void 0 : monitor.location.id;
  return (0, _react.useMemo)(() => {
    if (!locationsLoaded || monitor.location.label) {
      var _monitor$location$lab;
      return (_monitor$location$lab = monitor.location.label) !== null && _monitor$location$lab !== void 0 ? _monitor$location$lab : monitor.location.id;
    } else {
      var _location$label;
      const location = locations.find(loc => loc.id === locationId);
      return (_location$label = location === null || location === void 0 ? void 0 : location.label) !== null && _location$label !== void 0 ? _location$label : monitor.location.label || monitor.location.id;
    }
  }, [locationsLoaded, locations, locationId, monitor]);
}