"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeRangeFilter = void 0;
exports.useLastXChecks = useLastXChecks;
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_redux_es_search = require("./use_redux_es_search");
var _client_defaults = require("../../../../common/constants/client_defaults");
var _state = require("../state");
var _synthetics_refresh_context = require("../contexts/synthetics_refresh_context");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimeRangeFilter = schedule => {
  const inMinutes = Number(schedule);
  const fiftyChecksInMinutes = inMinutes * 50;
  const hours = Math.ceil(fiftyChecksInMinutes / 60);
  return {
    range: {
      '@timestamp': {
        gte: `now-${hours}h`,
        lte: 'now'
      }
    }
  };
};
exports.getTimeRangeFilter = getTimeRangeFilter;
function useLastXChecks({
  monitorId,
  locationId,
  fields = ['*'],
  size = 50,
  timestamp,
  schedule
}) {
  var _locations$find, _data$hits;
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const {
    locationsLoaded,
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const params = (0, _public.createEsParams)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size,
      query: {
        bool: {
          filter: [_client_defaults.FINAL_SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, getTimeRangeFilter(schedule), {
            term: {
              'monitor.id': monitorId
            }
          }],
          ...(0, _client_defaults.getLocationFilter)({
            locationId,
            locationName: ((_locations$find = locations.find(location => location.id === locationId)) === null || _locations$find === void 0 ? void 0 : _locations$find.label) || _constants.UNNAMED_LOCATION
          })
        }
      },
      _source: false,
      sort: [{
        '@timestamp': 'desc'
      }],
      fields
    }
  });
  const {
    data
  } = (0, _use_redux_es_search.useReduxEsSearch)(params, [lastRefresh], {
    name: `zGetLastXChecks/${monitorId}/${locationId}`,
    isRequestReady: locationsLoaded && Boolean(timestamp) // don't run query until locations are loaded
  });
  const dataAsJSON = JSON.stringify(data === null || data === void 0 ? void 0 : (_data$hits = data.hits) === null || _data$hits === void 0 ? void 0 : _data$hits.hits);
  return (0, _react.useMemo)(() => {
    var _data$hits2;
    return {
      hits: (data === null || data === void 0 ? void 0 : (_data$hits2 = data.hits) === null || _data$hits2 === void 0 ? void 0 : _data$hits2.hits.map(hit => hit.fields)) || [],
      loading: !data
    };
  }, [dataAsJSON]); // eslint-disable-line react-hooks/exhaustive-deps
}