"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = exports.makeBaseBreadcrumb = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _url_params = require("../utils/url_params");
var _use_url_params = require("./use_url_params");
var _plugin = require("../../../../common/constants/plugin");
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_QUERY = '?';
function handleBreadcrumbClick(breadcrumbs, navigateToHref) {
  return breadcrumbs.map(bc => ({
    ...bc,
    ...(bc.href ? {
      onClick: event => {
        if (navigateToHref && bc.href) {
          event.preventDefault();
          navigateToHref(bc.href);
        }
      }
    } : {}),
    ...(bc['data-test-subj'] ? {
      'data-test-subj': bc['data-test-subj']
    } : {
      'data-test-subj': bc.href
    })
  }));
}
const makeBaseBreadcrumb = (uptimePath, observabilityPath, params, isServerless) => {
  if (params) {
    const crumbParams = {
      ...params
    };
    delete crumbParams.statusFilter;
    const query = (0, _url_params.stringifyUrlParams)(crumbParams, true);
    uptimePath += query === EMPTY_QUERY ? '' : query;
  }
  const baseBreadcrumbs = [];

  // serverless Kibana has a curated UX flow, and "Observability" is already a given,
  // thus we don't need to include it explicitly in the breadcrumb trail
  if (!isServerless) {
    baseBreadcrumbs.push({
      text: _i18n.i18n.translate('xpack.synthetics.breadcrumbs.observabilityText', {
        defaultMessage: 'Observability'
      }),
      href: observabilityPath,
      'data-test-subj': 'observabilityPathBreadcrumb'
    });
  }
  baseBreadcrumbs.push({
    text: _i18n.i18n.translate('xpack.synthetics.breadcrumbs.overviewBreadcrumbText', {
      defaultMessage: 'Synthetics'
    }),
    href: uptimePath,
    'data-test-subj': 'syntheticsPathBreadcrumb'
  });
  return baseBreadcrumbs;
};
exports.makeBaseBreadcrumb = makeBaseBreadcrumb;
const useBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2, _kibana$services$appl3, _kibana$services$appl4, _kibana$services$appl5;
  const params = (0, _use_url_params.useUrlParams)()[0]();
  const kibana = (0, _public.useKibana)();
  const {
    setBreadcrumbs,
    isServerless
  } = (0, _react.useContext)(_contexts.SyntheticsSettingsContext);
  const syntheticsPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const observabilityPath = (_kibana$services$appl3 = (_kibana$services$appl4 = kibana.services.application) === null || _kibana$services$appl4 === void 0 ? void 0 : _kibana$services$appl4.getUrlForApp('observability-overview')) !== null && _kibana$services$appl3 !== void 0 ? _kibana$services$appl3 : '';
  const navigate = (_kibana$services$appl5 = kibana.services.application) === null || _kibana$services$appl5 === void 0 ? void 0 : _kibana$services$appl5.navigateToUrl;
  (0, _react.useEffect)(() => {
    if (setBreadcrumbs) {
      setBreadcrumbs(handleBreadcrumbClick(makeBaseBreadcrumb(syntheticsPath, observabilityPath, params, isServerless).concat(extraCrumbs), navigate));
    }
  }, [syntheticsPath, observabilityPath, extraCrumbs, navigate, params, setBreadcrumbs, isServerless]);
};
exports.useBreadcrumbs = useBreadcrumbs;