"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsThemeContext = exports.SyntheticsThemeContextProvider = exports.SyntheticsThemeContext = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These are default values for the context. These defaults are typically
 * overwritten by the Synthetics App upon its invocation.
 */
const defaultContext = {
  colors: {
    danger: _uiTheme.euiLightVars.euiColorDanger,
    dangerBehindText: _uiTheme.euiDarkVars.euiColorVis9_behindText,
    mean: _uiTheme.euiLightVars.euiColorPrimary,
    range: _uiTheme.euiLightVars.euiFocusBackgroundColor,
    success: _uiTheme.euiLightVars.euiColorSuccess,
    warning: _uiTheme.euiLightVars.euiColorWarning,
    gray: _uiTheme.euiLightVars.euiColorLightShade,
    lightestShade: _uiTheme.euiLightVars.euiColorLightestShade
  },
  chartTheme: {
    baseTheme: _charts.LIGHT_THEME
  }
};
const SyntheticsThemeContext = exports.SyntheticsThemeContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
const SyntheticsThemeContextProvider = ({
  darkMode,
  children
}) => {
  let colors;
  if (darkMode) {
    colors = {
      danger: _uiTheme.euiDarkVars.euiColorVis9,
      dangerBehindText: _uiTheme.euiDarkVars.euiColorVis9_behindText,
      mean: _uiTheme.euiDarkVars.euiColorPrimary,
      gray: _uiTheme.euiDarkVars.euiColorLightShade,
      range: _uiTheme.euiDarkVars.euiFocusBackgroundColor,
      success: _uiTheme.euiDarkVars.euiColorSuccess,
      warning: _uiTheme.euiDarkVars.euiColorWarning,
      lightestShade: _uiTheme.euiDarkVars.euiColorLightestShade
    };
  } else {
    colors = {
      danger: _uiTheme.euiLightVars.euiColorVis9,
      dangerBehindText: _uiTheme.euiLightVars.euiColorVis9_behindText,
      mean: _uiTheme.euiLightVars.euiColorPrimary,
      gray: _uiTheme.euiLightVars.euiColorLightShade,
      range: _uiTheme.euiLightVars.euiFocusBackgroundColor,
      success: _uiTheme.euiLightVars.euiColorSuccess,
      warning: _uiTheme.euiLightVars.euiColorWarning,
      lightestShade: _uiTheme.euiLightVars.euiColorLightestShade
    };
  }
  const value = (0, _react.useMemo)(() => {
    return {
      colors,
      chartTheme: {
        baseTheme: darkMode ? _charts.DARK_THEME : _charts.LIGHT_THEME
      }
    };
  }, [colors, darkMode]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsThemeContext.Provider, {
    value: value,
    children: children
  });
};
exports.SyntheticsThemeContextProvider = SyntheticsThemeContextProvider;
const useSyntheticsThemeContext = () => (0, _react.useContext)(SyntheticsThemeContext);
exports.useSyntheticsThemeContext = useSyntheticsThemeContext;