"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsRefreshContext = exports.SyntheticsRefreshContextProvider = exports.SyntheticsRefreshContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactUse = require("react-use");
var _moment = _interopRequireDefault(require("moment"));
var _state = require("../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultContext = {
  lastRefresh: 0,
  refreshApp: () => {
    throw new Error('App refresh was not initialized, set it when you invoke the context');
  }
};
const SyntheticsRefreshContext = exports.SyntheticsRefreshContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
const SyntheticsRefreshContextProvider = ({
  children
}) => {
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(Date.now());
  const refreshPaused = (0, _reactRedux.useSelector)(_state.selectRefreshPaused);
  const refreshInterval = (0, _reactRedux.useSelector)(_state.selectRefreshInterval);
  const refreshApp = (0, _react.useCallback)(() => {
    const refreshTime = Date.now();
    setLastRefresh(refreshTime);
  }, [setLastRefresh]);
  (0, _react.useEffect)(() => {
    if (!refreshPaused) {
      refreshApp();
    }
  }, [refreshApp, refreshPaused]);
  const value = (0, _react.useMemo)(() => {
    return {
      lastRefresh,
      refreshApp
    };
  }, [lastRefresh, refreshApp]);
  (0, _reactUse.useEvent)('visibilitychange', () => {
    const isOutdated = (0, _moment.default)().diff(new Date(lastRefresh), 'seconds') > refreshInterval;
    if (document.visibilityState !== 'hidden' && !refreshPaused && isOutdated) {
      refreshApp();
    }
  }, document);
  (0, _react.useEffect)(() => {
    if (refreshPaused) {
      return;
    }
    const interval = setInterval(() => {
      if (document.visibilityState !== 'hidden') {
        refreshApp();
      }
    }, refreshInterval * 1000);
    return () => clearInterval(interval);
  }, [refreshPaused, refreshApp, refreshInterval]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsRefreshContext.Provider, {
    value: value,
    children: children
  });
};
exports.SyntheticsRefreshContextProvider = SyntheticsRefreshContextProvider;
const useSyntheticsRefreshContext = () => (0, _react.useContext)(SyntheticsRefreshContext);
exports.useSyntheticsRefreshContext = useSyntheticsRefreshContext;