"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _test_run_error_info = require("./components/test_run_error_info");
var _monitor_details_panel_container = require("../monitor_details/monitor_summary/monitor_details_panel_container");
var _use_selected_location = require("../monitor_details/hooks/use_selected_location");
var _monitor_details_portal = require("../monitor_add_edit/monitor_details_portal");
var _step_number_nav = require("./components/step_number_nav");
var _step_screenshot_details = require("./step_screenshot_details");
var _step_tabs = require("./step_tabs");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _step_duration_panel = require("../monitor_details/monitor_summary/step_duration_panel");
var _test_run_steps = require("./test_run_steps");
var _use_test_run_details_breadcrumbs = require("./hooks/use_test_run_details_breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestRunDetails = () => {
  var _stepsData$details, _stepsData$details2, _stepsData$details2$s, _stepsData$details2$s2, _stepsData$steps, _stepsData$details$jo, _stepsData$details3;
  // Step index from starts at 1 in synthetics
  const [stepIndex, setStepIndex] = _react.default.useState(1);
  const {
    data: stepsData,
    loading: stepsLoading,
    stepEnds
  } = (0, _use_journey_steps.useJourneySteps)();
  (0, _use_test_run_details_breadcrumbs.useTestRunDetailsBreadcrumbs)([{
    text: stepsData ? (0, _moment.default)((_stepsData$details = stepsData.details) === null || _stepsData$details === void 0 ? void 0 : _stepsData$details.timestamp).format('LLL') : ''
  }]);
  const step = stepEnds.find(stepN => {
    var _stepN$synthetics, _stepN$synthetics$ste;
    return ((_stepN$synthetics = stepN.synthetics) === null || _stepN$synthetics === void 0 ? void 0 : (_stepN$synthetics$ste = _stepN$synthetics.step) === null || _stepN$synthetics$ste === void 0 ? void 0 : _stepN$synthetics$ste.index) === stepIndex;
  });
  const totalSteps = stepsLoading ? 1 : stepEnds.length;
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const stateId = stepsData === null || stepsData === void 0 ? void 0 : (_stepsData$details2 = stepsData.details) === null || _stepsData$details2 === void 0 ? void 0 : (_stepsData$details2$s = _stepsData$details2.summary) === null || _stepsData$details2$s === void 0 ? void 0 : (_stepsData$details2$s2 = _stepsData$details2$s.state) === null || _stepsData$details2$s2 === void 0 ? void 0 : _stepsData$details2$s2.id;
  const hasNoSteps = (stepsData === null || stepsData === void 0 ? void 0 : stepsData.steps.length) === 0 && !stepsLoading;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_test_run_error_info.TestRunErrorInfo, {
    journeyDetails: stepsData === null || stepsData === void 0 ? void 0 : stepsData.details,
    hasNoSteps: hasNoSteps
  }), !hasNoSteps && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexBasis: '60%',
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.testDetail.totalSteps",
    defaultMessage: "Step {stepIndex} of {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_step_number_nav.StepNumberNav, {
    stepIndex: stepIndex,
    totalSteps: totalSteps,
    handleNextStep: () => {
      setStepIndex(stepIndex + 1);
    },
    handlePreviousStep: () => {
      setStepIndex(stepIndex - 1);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_screenshot_details.StepScreenshotDetails, {
    stepIndex: stepIndex,
    step: step,
    stateId: stateId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_tabs.StepTabs, {
    stepsList: stepsData === null || stepsData === void 0 ? void 0 : stepsData.steps,
    step: step,
    loading: stepsLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_test_run_steps.TestRunSteps, {
    isLoading: stepsLoading,
    steps: (_stepsData$steps = stepsData === null || stepsData === void 0 ? void 0 : stepsData.steps) !== null && _stepsData$steps !== void 0 ? _stepsData$steps : []
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_test_run_error_info.TestRunErrorInfo, {
    journeyDetails: stepsData === null || stepsData === void 0 ? void 0 : stepsData.details,
    showErrorTitle: false,
    showErrorLogs: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexBasis: '36%',
      minWidth: 'min-content'
    }
  }, /*#__PURE__*/_react.default.createElement(_step_duration_panel.StepDurationPanel, {
    legendPosition: "bottom"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_panel_container.MonitorDetailsPanelContainer, {
    hideEnabled: true,
    hideLocations: true
  }))), /*#__PURE__*/_react.default.createElement(_monitor_details_portal.MonitorDetailsLinkPortal, {
    configId: monitorId,
    name: (_stepsData$details$jo = stepsData === null || stepsData === void 0 ? void 0 : (_stepsData$details3 = stepsData.details) === null || _stepsData$details3 === void 0 ? void 0 : _stepsData$details3.journey.monitor.name) !== null && _stepsData$details$jo !== void 0 ? _stepsData$details$jo : '',
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
  }));
};
exports.TestRunDetails = TestRunDetails;