"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSettingsRouteConfig = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _settings_page = require("./settings_page");
var _page_header = require("./page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSettingsRouteConfig = (history, syntheticsPath, baseTitle) => {
  const sharedProps = {
    title: _i18n.i18n.translate('xpack.synthetics.settingsRoute.title', {
      defaultMessage: 'Settings | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    component: _settings_page.SettingsPage,
    pageHeader: (0, _page_header.getSettingsPageHeader)(history, syntheticsPath),
    dataTestSubj: 'syntheticsSettingsPage',
    pageSectionProps: {
      paddingSize: 'm'
    }
  };
  return [{
    ...sharedProps,
    path: _constants.SETTINGS_ROUTE
  }, {
    ...sharedProps,
    path: _constants.SYNTHETICS_SETTINGS_ROUTE
  }];
};
exports.getSettingsRouteConfig = getSettingsRouteConfig;